/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job.model.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.ibm.optim.oaas.client.job.model.Job;
import com.ibm.optim.oaas.client.job.model.JobAttachment;
import com.ibm.optim.oaas.client.job.model.JobExecutionStatus;
import com.ibm.optim.oaas.client.job.model.JobInterruptionStatus;
import com.ibm.optim.oaas.client.job.model.JobParameters;
import com.ibm.optim.oaas.client.job.model.JobSolveStatus;
import com.ibm.optim.oaas.client.job.model.impl.DocumentImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobApiClientImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobAttachmentImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobDetailsImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobFailureInfoImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobParametersImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobSubscriberImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobSubscriptionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class JobImpl
extends DocumentImpl
implements Job {
    public static final String TYPE = "job";
    @JsonView(value={DocumentImpl.StorageView.class})
    @JsonProperty(value="type")
    private final String type = "job";
    private String applicationId;
    private String applicationVersion;
    private String applicationVersionUsed;
    private String language = "en-US";
    private JobExecutionStatus executionStatus;
    private JobSolveStatus solveStatus;
    private JobInterruptionStatus interruptionStatus;
    private String owner;
    private String processingOwner;
    private String lastProcessingOwner;
    private Date createdAt;
    private Date submittedAt;
    private Date submittedToProcessorAt;
    private Date startedAt;
    private Date interruptedAt;
    private Date endedAt;
    private Date endRecordedAt;
    private Date updatedAt;
    private final JobParametersImpl parameters = new JobParametersImpl();
    private Map<String, String> details;
    private Map<String, String> systemDetails;
    private List<JobAttachmentImpl> attachments = new ArrayList<JobAttachmentImpl>();
    private JobFailureInfoImpl failure;
    private Long nbLogItems;
    private JobSubscriptionImpl subscription = new JobSubscriptionImpl();
    private Integer initialQueueIndex;
    private Integer currentQueueIndex;
    @JsonView(value={DocumentImpl.StorageView.class})
    private List<String> merged;
    @JsonView(value={DocumentImpl.StorageView.class})
    private String token;
    private JobApiClientImpl apiClient;
    private JobSubscriberImpl subscriber;
    @JsonIgnore
    private JobDetailsImpl lastDetails;
    @JsonView(value={DocumentImpl.StorageView.class})
    private int storageVersion;
    @JsonIgnore
    private boolean ignoreJobCount;

    public Integer getInitialQueueIndex() {
        return this.initialQueueIndex;
    }

    public void setInitialQueueIndex(Integer initialQueueIndex) {
        this.initialQueueIndex = initialQueueIndex;
    }

    public Integer getCurrentQueueIndex() {
        return this.currentQueueIndex;
    }

    public void setCurrentQueueIndex(Integer currentQueueIndex) {
        this.currentQueueIndex = currentQueueIndex;
    }

    public List<String> getMerged() {
        return this.merged;
    }

    public void addToMerged(List<String> tomerge) {
        if (this.merged == null) {
            this.merged = new ArrayList<String>();
            this.merged.addAll(tomerge);
        } else {
            for (String rev : tomerge) {
                if (this.merged.contains(rev)) continue;
                this.merged.add(rev);
            }
        }
    }

    public List<String> getUnmergedConflicts() {
        if (this.getConflicts() == null) {
            return Collections.emptyList();
        }
        if (this.merged == null) {
            return this.getConflicts();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String rev : this.getConflicts()) {
            if (this.merged.contains(rev)) continue;
            list.add(rev);
        }
        return list;
    }

    public boolean needMerge() {
        return this.getConflicts() != null && (this.merged == null || !this.merged.containsAll(this.getConflicts()));
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    @Override
    public String getApplicationVersionUsed() {
        return this.applicationVersionUsed;
    }

    public void setApplicationVersionUsed(String applicationVersionUsed) {
        this.applicationVersionUsed = applicationVersionUsed;
    }

    @Override
    public JobExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(JobExecutionStatus status) {
        this.executionStatus = status;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Override
    public Date getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    @Override
    public Date getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(Date endedAt) {
        this.endedAt = endedAt;
    }

    @Override
    public Date getEndRecordedAt() {
        return this.endRecordedAt;
    }

    public void setEndRecordedAt(Date endRecordedAt) {
        this.endRecordedAt = endRecordedAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    public JobParameters getParameters() {
        return this.parameters;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public void setParameters(JobParameters parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    @Override
    public String getProcessingOwner() {
        return this.processingOwner;
    }

    public void setProcessingOwner(String owner) {
        this.lastProcessingOwner = this.processingOwner;
        this.processingOwner = owner;
    }

    @Override
    public String getLastProcessingOwner() {
        return this.lastProcessingOwner;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String toString() {
        return "[id=" + this.getId() + ",status=" + (Object)((Object)this.getExecutionStatus()) + ",owner=" + this.getOwner() + ",processing=" + this.getProcessingOwner() + "]";
    }

    @Override
    public List<JobAttachment> getAttachments() {
        List<JobAttachment> list = this.attachments;
        return list;
    }

    public List<JobAttachmentImpl> getImplAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<JobAttachmentImpl> attachments) {
        this.attachments = attachments;
    }

    @Override
    public JobAttachmentImpl getAttachment(String name) {
        for (JobAttachmentImpl att : this.attachments) {
            if (!att.getName().equals(name)) continue;
            return att;
        }
        return null;
    }

    @Override
    public JobFailureInfoImpl getFailureInfo() {
        return this.failure;
    }

    public void setFailureInfo(JobFailureInfoImpl failure) {
        this.failure = failure;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setSystemDetails(Map<String, String> details) {
        this.systemDetails = details;
    }

    public Map<String, String> getSystemDetails() {
        return this.systemDetails;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    @Override
    public JobSolveStatus getSolveStatus() {
        return this.solveStatus;
    }

    public void setSolveStatus(JobSolveStatus solveStatus) {
        this.solveStatus = solveStatus;
    }

    @Override
    public JobInterruptionStatus getInterruptionStatus() {
        return this.interruptionStatus;
    }

    public void setInterruptionStatus(JobInterruptionStatus interruptionStatus) {
        this.interruptionStatus = interruptionStatus;
    }

    @Override
    public Date getInterruptedAt() {
        return this.interruptedAt;
    }

    public void setInterruptedAt(Date interruptedAt) {
        this.interruptedAt = interruptedAt;
    }

    @Override
    public Date getSubmittedAt() {
        return this.submittedAt;
    }

    public void setSubmittedAt(Date submittedAt) {
        this.submittedAt = submittedAt;
    }

    public Date getSubmittedToProcessorAt() {
        return this.submittedToProcessorAt;
    }

    public void setSubmittedToProcessorAt(Date submittedToProcessorAt) {
        this.submittedToProcessorAt = submittedToProcessorAt;
    }

    @Override
    public Long getNbLogItems() {
        return this.nbLogItems;
    }

    public void setNbLogItems(Long nbLogItems) {
        this.nbLogItems = nbLogItems;
    }

    @Override
    public JobSubscriptionImpl getSubscription() {
        return this.subscription;
    }

    public void setSubscription(JobSubscriptionImpl subscription) {
        this.subscription = subscription;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getSubscriptionId() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    @Override
    public JobApiClientImpl getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(JobApiClientImpl apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public JobSubscriberImpl getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(JobSubscriberImpl subscriber) {
        this.subscriber = subscriber;
    }

    public int getStorageVersion() {
        return this.storageVersion;
    }

    public void setStorageVersion(int storageVersion) {
        this.storageVersion = storageVersion;
    }

    public JobDetailsImpl getLastDetails() {
        return this.lastDetails;
    }

    public void setLastDetails(JobDetailsImpl lastDetails) {
        this.lastDetails = lastDetails;
    }

    public String getETag() {
        if (this.lastDetails != null) {
            return this.getRev() + this.lastDetails.getRev();
        }
        return this.getRev();
    }

    public boolean isIgnoreJobCount() {
        return this.ignoreJobCount;
    }

    public void setIgnoreJobCount(boolean ignoreJobCount) {
        this.ignoreJobCount = ignoreJobCount;
    }

    public String getEmailForNotification() {
        if (this.getApiClient() != null) {
            return this.getApiClient().getEmail();
        }
        if (this.getSubscriber() != null) {
            return this.getSubscriber().getEmail();
        }
        return null;
    }
}

