/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client;

import com.ibm.optim.oaas.client.impl.MessageHandler;

public class OaasRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Object[] parameters;
    private MessageHandler messageHandler;

    public OaasRuntimeException(String message, Throwable cause, Object ... parameters) {
        super(message, cause);
        this.parameters = parameters;
    }

    public OaasRuntimeException(String message, Object ... parameters) {
        super(message);
        this.parameters = parameters;
    }

    public OaasRuntimeException(Throwable cause) {
        super(cause);
        this.parameters = null;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    private synchronized MessageHandler getMessageHandler() {
        String bundle;
        if (this.messageHandler == null && (bundle = this.getResourceBundleName()) != null) {
            this.messageHandler = new MessageHandler(bundle, Boolean.TRUE, this.getClassLoader());
        }
        return this.messageHandler;
    }

    public String getLocalizedMessage(String localeName) {
        MessageHandler handler = this.getMessageHandler();
        if (handler != null) {
            return handler.getLocalizedMessageWithLocale(localeName, super.getMessage(), this.getParameters());
        }
        return super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(null);
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage();
    }

    protected String getResourceBundleName() {
        return null;
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable deepestError;
        for (deepestError = throwable; deepestError.getCause() != null && deepestError != deepestError.getCause(); deepestError = deepestError.getCause()) {
        }
        return deepestError;
    }

    public int getRestStatusCode() {
        return 500;
    }

    public String getMessageCode() {
        return super.getMessage();
    }
}

