/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class OaasMessageCode {
    private static final Object[] OBJECT_EMPTYARRAY = new Object[0];
    private String _name;
    private String _loggerName;
    private String _rbName;
    private CharSequence _prefixCache;

    public final String name() {
        return this._name;
    }

    public final String getLoggerName() {
        return this._loggerName;
    }

    public Logger getLogger() {
        return Logger.getLogger(this.getLoggerName());
    }

    public final String getResourceBundleName() {
        return this._rbName;
    }

    protected String getResourceValue() {
        return ResourceBundle.getBundle(this.getResourceBundleName()).getString(this.name());
    }

    public final Level getLevel() {
        Level level = Level.INFO;
        switch (this.name().charAt(9)) {
            case 'I': {
                level = Level.INFO;
                break;
            }
            case 'W': {
                level = Level.WARNING;
                break;
            }
            case 'E': {
                level = Level.SEVERE;
                break;
            }
            case 'F': {
                level = Level.FINEST;
            }
        }
        return level;
    }

    public final void log(Object ... parameters) {
        Throwable throwable = null;
        if (parameters != null && parameters.length > 0 && parameters[parameters.length - 1] instanceof Throwable) {
            throwable = (Throwable)parameters[parameters.length - 1];
        }
        this.log(throwable, parameters);
    }

    public final void log(Throwable throwable) {
        this.log(throwable, (Object[])null);
    }

    public final void log(Throwable throwable, Object ... parameters) {
        this.log(this.getLogger(), throwable, parameters);
    }

    public final void log(Logger logger, Throwable throwable, Object ... parameters) {
        Level level = this.getLevel();
        if (logger.isLoggable(level)) {
            if (parameters == null) {
                parameters = OBJECT_EMPTYARRAY;
            }
            StringBuffer sbMsg = this.formatMessage(this.getMessageFormat(parameters.length), parameters);
            if (throwable == null) {
                logger.log(level, sbMsg.toString());
            } else {
                logger.log(level, sbMsg.toString(), throwable);
            }
        }
    }

    protected MessageFormat getMessageFormat(int parametersCount) {
        String resourceValue;
        try {
            resourceValue = this.getResourceValue();
        }
        catch (MissingResourceException mre) {
            resourceValue = this.name();
        }
        return this.getMessageFormat(resourceValue, parametersCount);
    }

    private MessageFormat getMessageFormat(String resourceValue, int parametersCount) {
        MessageFormat messageFormat;
        try {
            messageFormat = new MessageFormat(resourceValue);
        }
        catch (Throwable th) {
            messageFormat = this.generatePlaceholderFormatter(th, resourceValue, parametersCount);
        }
        return messageFormat;
    }

    private MessageFormat generatePlaceholderFormatter(Throwable cause, String faultyFormat, int paramCount) {
        StringBuffer causeHint = new StringBuffer(cause.getMessage()).append(" [").append(faultyFormat).append("]: ");
        block6: for (int i = 0; i < causeHint.length(); ++i) {
            char cur = causeHint.charAt(i);
            switch (cur) {
                case '\'': {
                    causeHint.insert(i, '\'');
                    ++i;
                    continue block6;
                }
                case '{': 
                case '}': {
                    causeHint.insert(i, '\'');
                    causeHint.insert(i += 2, '\'');
                }
            }
        }
        causeHint.append('[').append(this.getResourceBundleName()).append(':').append(this.name()).append("] ");
        for (int iP = 0; iP < paramCount; ++iP) {
            causeHint.append("\"{").append(iP).append("}\"; ");
        }
        causeHint.setLength(causeHint.length() - 2);
        try {
            return new MessageFormat(causeHint.toString());
        }
        catch (Throwable th) {
            return new MessageFormat("Throwable occurred " + th.getClass().getCanonicalName());
        }
    }

    private static int appendParameters(StringBuffer sbMsg, int startFromParam, Object ... parameters) {
        if (parameters == null || parameters.length <= startFromParam) {
            return 0;
        }
        sbMsg.append(" [");
        for (int iP = startFromParam; iP < parameters.length; ++iP) {
            sbMsg.append(iP).append('=');
            try {
                sbMsg.append(parameters[iP]);
            }
            catch (Throwable thParamToString) {
                sbMsg.append(thParamToString.getClass().getCanonicalName());
            }
            sbMsg.append("; ");
        }
        sbMsg.setLength(sbMsg.length() - 2);
        sbMsg.append(']');
        return parameters.length;
    }

    protected StringBuffer formatMessage(MessageFormat messageFormat, Object ... parameters) {
        StringBuffer sbMsg;
        try {
            sbMsg = new StringBuffer(this.getLogMessagePrefix());
            messageFormat.format(parameters, sbMsg, (FieldPosition)null);
            Format[] fmts = messageFormat.getFormats();
            int fmtCount = fmts.length;
            if (fmtCount < parameters.length) {
                OaasMessageCode.appendParameters(sbMsg, fmtCount, parameters);
            }
        }
        catch (Throwable th) {
            sbMsg = new StringBuffer(this.getLogMessagePrefix()).append(" ").append(messageFormat.toPattern());
            OaasMessageCode.appendParameters(sbMsg, 0, parameters);
        }
        return sbMsg;
    }

    private CharSequence getLogMessagePrefix() {
        if (this._prefixCache == null) {
            this._prefixCache = new StringBuilder(this.name().substring(0, 10)).append(": ");
        }
        return this._prefixCache;
    }

    private void logf(Level level, String fmtMsg, Object ... params) {
        if (this.isLoggable(level)) {
            if (params != null && params.length > 0) {
                StringBuffer sbMsg;
                try {
                    sbMsg = this.formatMessage(new MessageFormat(fmtMsg), params);
                }
                catch (Throwable th) {
                    sbMsg = new StringBuffer(fmtMsg).append(": ");
                    OaasMessageCode.appendParameters(sbMsg, 0, params);
                }
                fmtMsg = sbMsg.toString();
            }
            this.getLogger().log(level, fmtMsg);
        }
    }

    public void fine(String fmt, Object ... params) {
        this.logf(Level.FINE, fmt, params);
    }

    public void finest(String fmt, Object ... params) {
        this.logf(Level.FINEST, fmt, params);
    }

    public void fine(OaasMessageCode code, Object ... params) {
        this.fine(code.getResourceValue(), params);
    }

    public void entering(String sourceClass, String sourceMethod, Object ... params) {
        this.getLogger().entering(sourceClass, sourceMethod, params);
    }

    public String extractMessage(Object ... parameters) {
        return this.formatMessage(this.getMessageFormat(parameters.length), parameters).toString();
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.getLevel().intValue() && this.getLogger().isLoggable(level);
    }

    public static void initializeCodes(Class<? extends OaasMessageCode> clazz, String loggerName, String resourceBundleName) {
        for (Field field : clazz.getDeclaredFields()) {
            Class<?> fieldType = field.getType();
            if (!Modifier.isStatic(field.getModifiers()) || !OaasMessageCode.class.isAssignableFrom(fieldType)) continue;
            try {
                OaasMessageCode code = (OaasMessageCode)field.get(null);
                if (code == null) {
                    code = (OaasMessageCode)(clazz.isAssignableFrom(fieldType) ? fieldType : clazz).newInstance();
                }
                if (code._loggerName == null) {
                    code._loggerName = loggerName;
                }
                if (code._rbName == null) {
                    code._rbName = resourceBundleName;
                }
                if (code._name == null) {
                    code._name = field.getName();
                }
                field.set(null, code);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void initializeCodes(Class<? extends OaasMessageCode> clazz, String loggerName) {
        OaasMessageCode.initializeCodes(clazz, loggerName, clazz.getName());
    }
}

