/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job.impl;

import com.ibm.optim.oaas.client.impl.Validate;
import com.ibm.optim.oaas.client.job.JobExecutor;
import com.ibm.optim.oaas.client.job.JobExecutorBuilder;
import com.ibm.optim.oaas.client.job.impl.JobExecutorImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class JobExecutorBuilderImpl
implements JobExecutorBuilder {
    private long timeout = -1L;
    private long interval = 5000L;
    private int threads = 10;
    private int retry = 3;
    private long retryDelay = 4000L;
    private ExecutorService service;

    @Override
    public JobExecutorBuilder threads(int threads) {
        Validate.strictlyPositive(threads, "threads");
        this.threads = threads;
        return this;
    }

    @Override
    public JobExecutorBuilder interval(long interval, TimeUnit unit) {
        Validate.strictlyPositive(interval, "interval");
        Validate.notNull(unit, "unit");
        this.interval = unit.toMillis(interval);
        return this;
    }

    @Override
    public JobExecutorBuilder timeout(long timeout, TimeUnit unit) {
        Validate.notNull(unit, "unit");
        this.timeout = timeout > 0L ? unit.toMillis(timeout) : timeout;
        return this;
    }

    @Override
    public JobExecutorBuilder service(ExecutorService service) {
        Validate.notNull(service, "service");
        this.service = service;
        return this;
    }

    @Override
    public JobExecutorBuilder retry(int retry) {
        this.retry = retry;
        return this;
    }

    @Override
    public JobExecutorBuilder retryDelay(long delay, TimeUnit unit) {
        Validate.strictlyPositive(delay, "delay");
        Validate.notNull(unit, "unit");
        this.retryDelay = unit.toMillis(delay);
        return this;
    }

    @Override
    public JobExecutor build() {
        ExecutorService serviceConfig = this.service;
        if (serviceConfig == null) {
            serviceConfig = Executors.newFixedThreadPool(this.threads);
        }
        return new JobExecutorImpl(serviceConfig, this.interval, this.timeout, this.retry, this.retryDelay);
    }
}

