/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.optim.oaas.client.job.model.JobApiClient;
import com.ibm.optim.oaas.client.job.model.JobAttachment;
import com.ibm.optim.oaas.client.job.model.JobExecutionStatus;
import com.ibm.optim.oaas.client.job.model.JobFailureInfo;
import com.ibm.optim.oaas.client.job.model.JobInterruptionStatus;
import com.ibm.optim.oaas.client.job.model.JobParameters;
import com.ibm.optim.oaas.client.job.model.JobSolveStatus;
import com.ibm.optim.oaas.client.job.model.JobSubscriber;
import com.ibm.optim.oaas.client.job.model.JobSubscription;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import java.util.Map;

@ApiModel(value="Job", description="A job to be submitted for execution")
public interface Job {
    @ApiModelProperty(value="The job revision", required=true)
    @JsonProperty(value="_rev")
    public String getRev();

    @ApiModelProperty(value="The unique ID of the job", required=true)
    @JsonProperty(value="_id")
    public String getId();

    @ApiModelProperty(value="The ID of the application associated with the job")
    public String getApplicationId();

    @ApiModelProperty(value="The version of the application associated with the submitted job.")
    public String getApplicationVersion();

    @ApiModelProperty(value="The version of the application used during job processing.")
    public String getApplicationVersionUsed();

    @ApiModelProperty(value="The current execution status of the job", required=true)
    public JobExecutionStatus getExecutionStatus();

    @ApiModelProperty(value="The creation time of the job", dataType="long")
    public Date getCreatedAt();

    @ApiModelProperty(value="The start time of the job", dataType="long")
    public Date getStartedAt();

    @ApiModelProperty(value="The completion time of the job", dataType="long")
    public Date getEndedAt();

    @ApiModelProperty(value="The recorded completion time of the job", dataType="long")
    public Date getEndRecordedAt();

    @ApiModelProperty(value="The update time of the job details", dataType="long")
    public Date getUpdatedAt();

    @ApiModelProperty(value="Job parameters")
    public JobParameters getParameters();

    @ApiModelProperty(value="The processor ID currently executing the job")
    public String getProcessingOwner();

    @ApiModelProperty(value="The processor ID that executed the job")
    public String getLastProcessingOwner();

    @ApiModelProperty(value="The owner of the job")
    public String getOwner();

    @ApiModelProperty(value="Attachments to the job")
    public List<JobAttachment> getAttachments();

    public JobAttachment getAttachment(String var1);

    @ApiModelProperty(value="Job failure information")
    public JobFailureInfo getFailureInfo();

    @ApiModelProperty(value="The job language. This value is reserved for future use")
    public String getLanguage();

    @ApiModelProperty(value="Detailed job information")
    public Map<String, String> getDetails();

    @ApiModelProperty(value="The current solve status of the job")
    public JobSolveStatus getSolveStatus();

    @ApiModelProperty(value="The current interruption status of the job")
    public JobInterruptionStatus getInterruptionStatus();

    @ApiModelProperty(value="The interruption time of the job", dataType="long")
    public Date getInterruptedAt();

    @ApiModelProperty(value="The submission time of the job", dataType="long")
    public Date getSubmittedAt();

    @ApiModelProperty(value="The number of log items associated with the job, once it is completed")
    public Long getNbLogItems();

    @ApiModelProperty(value="Job subscription information", required=true)
    public JobSubscription getSubscription();

    @ApiModelProperty(value="Job subscriber information if it was submitted interactively")
    public JobSubscriber getSubscriber();

    @ApiModelProperty(value="Job API client information if it was submitted using the API")
    public JobApiClient getApiClient();
}

