/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;

public class KeysFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$keys");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$keys");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$keys");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        NullNode argObject = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argObject = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        if (!useContext) {
            argObject = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argObject == null) {
            return null;
        }
        if (argObject.isObject()) {
            ObjectNode obj = (ObjectNode)argObject;
            Iterator it = obj.fieldNames();
            while (it.hasNext()) {
                result.add((String)it.next());
            }
            return result;
        } else {
            if (!argObject.isArray()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            KeysFunction.findObjects((ArrayNode)argObject, result);
        }
        return result;
    }

    static void findObjects(ArrayNode array, ArrayNode result) {
        for (int i = 0; i < array.size(); ++i) {
            JsonNode arrayNode = array.get(i);
            if (arrayNode == null || arrayNode.isArray() || !arrayNode.isObject()) continue;
            KeysFunction.captureKeys((ObjectNode)arrayNode, result);
        }
    }

    static void captureKeys(ObjectNode argObject, ArrayNode result) {
        JsonNode value = null;
        String key = null;
        ObjectNode obj = argObject;
        Iterator it = obj.fieldNames();
        while (it.hasNext()) {
            key = (String)it.next();
            result.add(key);
            value = obj.get(key);
            if (value == null) continue;
        }
    }

    @Override
    public String getSignature() {
        return "<o-:a<s>>";
    }
}

