/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.issues;

import java.util.List;
import org.antlr.v4.runtime.misc.Utils;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;

public class TreeUtils {
    public static final String Eol = System.lineSeparator();
    public static final String Indents = "  ";
    private static int level;

    private TreeUtils() {
    }

    public static String toPrettyTree(Tree t, List<String> ruleNames) {
        level = 0;
        return TreeUtils.process(t, ruleNames).replaceAll("(?m)^\\s+$", "").replaceAll("\\r?\\n\\r?\\n", Eol);
    }

    private static String process(Tree t, List<String> ruleNames) {
        if (t.getChildCount() == 0) {
            return Utils.escapeWhitespace(Trees.getNodeText(t, ruleNames), false);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TreeUtils.lead(level));
        ++level;
        String s = Utils.escapeWhitespace(Trees.getNodeText(t, ruleNames), false);
        sb.append(s + " ");
        for (int i = 0; i < t.getChildCount(); ++i) {
            sb.append(TreeUtils.process(t.getChild(i), ruleNames));
        }
        sb.append(TreeUtils.lead(--level));
        return sb.toString();
    }

    private static String lead(int level) {
        StringBuilder sb = new StringBuilder();
        if (level > 0) {
            sb.append(Eol);
            for (int cnt = 0; cnt < level; ++cnt) {
                sb.append(Indents);
            }
        }
        return sb.toString();
    }
}

