/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;

public abstract class FunctionBase {
    public abstract int getMaxArgs();

    public abstract int getMinArgs();

    public abstract String getSignature();

    public abstract JsonNode invoke(ExpressionsVisitor var1, MappingExpressionParser.Function_callContext var2);

    protected CtxEvalResult evalContext(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode arg = null;
        int argCount = FunctionBase.getArgumentCount(ctx);
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        if (useContext) {
            arg = FunctionUtils.getContextVariable(expressionVisitor);
            if (arg != null && !arg.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount > 0 && !useContext && ctx.exprValues() != null && ctx.exprValues().exprList() != null && !ctx.exprValues().exprList().isEmpty()) {
            arg = expressionVisitor.visit(ctx.exprValues().exprList().expr(0));
        }
        return new CtxEvalResult(arg, argCount, useContext);
    }

    public String getFunctionName(MappingExpressionParser.Function_callContext ctx) {
        return ctx.VAR_ID().getText();
    }

    public static int getArgumentCount(MappingExpressionParser.Function_callContext ctx) {
        if (ctx.emptyValues() != null) {
            return 0;
        }
        if (ctx.exprValues().exprList() == null) {
            return 0;
        }
        return ctx.exprValues().exprList().expr().size();
    }

    protected class CtxEvalResult {
        public final JsonNode arg;
        public final int argumentCount;
        public final boolean useContext;

        public CtxEvalResult(JsonNode arg, int argumentCount, boolean useContext) {
            this.arg = arg;
            this.argumentCount = argumentCount;
            this.useContext = useContext;
        }
    }
}

