/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.antlr.v4.runtime.tree.TerminalNode;

public class FilterFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$filter");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$filter");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$filter");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$filter");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$spread");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ExpressionsVisitor.SelectorArrayNode result = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
        FunctionBase.CtxEvalResult ctxEvalResult = this.evalContext(expressionVisitor, ctx);
        JsonNode arg = ctxEvalResult.arg;
        int argCount = ctxEvalResult.argumentCount;
        boolean useContext = ctxEvalResult.useContext;
        switch (argCount) {
            case 0: {
                if (arg == null) break;
                throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
            }
            case 1: {
                DeclaredFunction fctArg = FunctionUtils.getFunctionArgFromCtx(expressionVisitor, ctx, true);
                if (fctArg != null) break;
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
            case 2: {
                if (arg == null) {
                    throw new EvaluateRuntimeException(String.format("Argument 1 of function %s does not match function signature", "$filter"));
                }
                ArrayNode mapArray = ExpressionsVisitor.ensureArray(arg);
                MappingExpressionParser.ExprValuesContext valuesCtx = ctx.exprValues();
                MappingExpressionParser.ExprListContext exprList = valuesCtx.exprList();
                MappingExpressionParser.ExprContext varid = exprList.expr(useContext ? 0 : 1);
                if (varid instanceof MappingExpressionParser.Var_recallContext) {
                    TerminalNode VAR_ID = ((MappingExpressionParser.Var_recallContext)varid).VAR_ID();
                    String varID = varid.getText();
                    DeclaredFunction fct = expressionVisitor.getDeclaredFunction(varID);
                    if (fct != null) {
                        int fctVarCount;
                        int varCount = fct.getVariableCount();
                        if (varCount > (fctVarCount = fct.getMaxArgs())) {
                            varCount = fctVarCount;
                        }
                        for (int i = 0; i < mapArray.size(); ++i) {
                            JsonNode element = mapArray.get(i);
                            MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                            switch (varCount) {
                                case 1: {
                                    evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                                    break;
                                }
                                case 2: {
                                    evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                                    evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                                    break;
                                }
                                case 3: {
                                    evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                                    evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                                    evc = FunctionUtils.addArrayExprVarContext(ctx, evc, mapArray);
                                }
                            }
                            JsonNode fctResult = fct.invoke(expressionVisitor, evc);
                            if (fctResult == null || !fctResult.asBoolean()) continue;
                            result.addAsSelectionGroup(element);
                        }
                    } else {
                        FunctionBase function = expressionVisitor.getJsonataFunction(varid.getText());
                        if (function == null) throw new EvaluateRuntimeException("Expected function variable reference " + varID + " to resolve to a declared nor Jsonata function.");
                        int optionalArgs = FunctionUtils.getOptionalArgCount(function.getSignature());
                        int maxArgs = function.getMaxArgs() - optionalArgs;
                        for (int i = 0; i < mapArray.size(); ++i) {
                            MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                            JsonNode element = mapArray.get(i);
                            JsonNode fctResult = null;
                            fctResult = maxArgs <= 1 ? FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, element) : (maxArgs == 2 ? FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, element, JsonNodeFactory.instance.numberNode(i)) : FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, element, JsonNodeFactory.instance.numberNode(i), mapArray));
                            if (fctResult == null || !fctResult.asBoolean()) continue;
                            result.addAsSelectionGroup(element);
                        }
                    }
                } else {
                    int fctVarCount;
                    MappingExpressionParser.ExprListContext fctBody;
                    if (!(varid instanceof MappingExpressionParser.Function_declContext)) break;
                    MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)exprList.expr(useContext ? 0 : 1);
                    MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
                    DeclaredFunction fct = new DeclaredFunction(varList, fctBody = fctDeclCtx.exprList());
                    int varCount = fct.getVariableCount();
                    if (varCount > (fctVarCount = fct.getMaxArgs())) {
                        varCount = fctVarCount;
                    }
                    for (int i = 0; i < mapArray.size(); ++i) {
                        JsonNode element = mapArray.get(i);
                        MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                        switch (varCount) {
                            case 1: {
                                evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                                break;
                            }
                            case 2: {
                                evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                                evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                                break;
                            }
                            case 3: {
                                evc = FunctionUtils.fillExprVarContext(varCount, ctx, element);
                                evc = FunctionUtils.addIndexExprVarContext(ctx, evc, i);
                                evc = FunctionUtils.addArrayExprVarContext(ctx, evc, mapArray);
                            }
                        }
                        JsonNode fctResult = fct.invoke(expressionVisitor, evc);
                        if (fctResult == null || !fctResult.asBoolean()) continue;
                        result.addAsSelectionGroup(element);
                    }
                }
                break;
            }
            default: {
                throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
            }
        }
        if (result.size() != 0) return result;
        return null;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 2;
    }

    @Override
    public String getSignature() {
        return "<af:a>";
    }

    public void addObject(ExpressionsVisitor.SelectorArrayNode result, ObjectNode obj) {
        Iterator<String> it = obj.fieldNames();
        while (it.hasNext()) {
            String key = it.next();
            ObjectNode cell = JsonNodeFactory.instance.objectNode();
            cell.set(key, obj.get(key));
            result.add(cell);
        }
    }
}

