/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.LinkedHashSet;

public class DistinctFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$distinct");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$distinct");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$distinct");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$distinct");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ArrayNode result = null;
        FunctionBase.CtxEvalResult ctxEvalResult = this.evalContext(expressionVisitor, ctx);
        JsonNode arg = ctxEvalResult.arg;
        int argCount = ctxEvalResult.argumentCount;
        boolean useContext = ctxEvalResult.useContext;
        if (argCount != 0 || arg != null) {
            if (argCount == 1) {
                if (arg == null || arg.isNull()) {
                    if (useContext) {
                        throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                    }
                } else if (arg.isArray()) {
                    result = this.distinct((ArrayNode)arg);
                } else {
                    result = JsonNodeFactory.instance.arrayNode();
                    result.add(arg);
                }
            } else {
                throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG2BADTYPE);
            }
        }
        return result;
    }

    private ArrayNode distinct(ArrayNode arg) {
        ExpressionsVisitor.SelectorArrayNode result = arg instanceof ExpressionsVisitor.SelectorArrayNode ? new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance) : JsonNodeFactory.instance.arrayNode();
        LinkedHashSet<JsonNode> nodeSet = new LinkedHashSet<JsonNode>();
        for (JsonNode node : arg) {
            nodeSet.add(node);
        }
        for (JsonNode node : nodeSet) {
            result.add(node);
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<x:a>";
    }
}

