/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import java.util.regex.Pattern;

public class RegularExpression {
    private final Type type;
    private String regexPattern;
    private Pattern pattern;

    public RegularExpression(String string) {
        this(Type.NORMAL, string);
    }

    public RegularExpression(Type type, String regex) {
        this.type = type;
        switch (type) {
            case CASEINSENSITIVE: 
            case MULTILINE: {
                this.regexPattern = regex.substring(1, regex.length() - 2);
                break;
            }
            default: {
                this.regexPattern = regex.substring(1, regex.length() - 1);
            }
        }
        this.compile();
    }

    private void compile() {
        switch (this.type) {
            case CASEINSENSITIVE: {
                this.pattern = Pattern.compile(this.regexPattern, 2);
                break;
            }
            case MULTILINE: {
                this.pattern = Pattern.compile(this.regexPattern, 8);
                break;
            }
            default: {
                this.pattern = Pattern.compile(this.regexPattern);
            }
        }
    }

    public String toString() {
        return this.regexPattern;
    }

    public Type getType() {
        return this.type;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public static enum Type {
        NORMAL,
        CASEINSENSITIVE,
        MULTILINE;

    }
}

