/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.testerui;

import com.api.jsonata4java.testerui.TesterUIColors;
import com.api.jsonata4java.testerui.TesterUIJsonataExample;
import com.api.jsonata4java.testerui.TesterUIProperties;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class TesterUISettings {
    public static final File SETTINGS_FOLDER = new File(System.getProperty("user.home") + File.separator + ".jsonata4java");
    public static final File SETTINGS_FILE = new File(SETTINGS_FOLDER, "preferences.properties");
    public static Path DEFAULT_PATH_INPUT = null;
    public static final Path DEFAULT_PATH_JSONATA;
    private TesterUIJsonataExample example = TesterUIJsonataExample.ADDRESS;
    private Path pathInput = this.example.getPathInput();
    private Path pathJsonata = this.example.getPathJsonata();
    private Color backgroundInput = TesterUIColors.EXERCISER.getColorInput();
    private Color backgroundJsonata = TesterUIColors.EXERCISER.getColorJsonata();
    private Color backgroundOutput = TesterUIColors.EXERCISER.getColorOutput();
    private Color backgroundError = TesterUIColors.EXERCISER.getColorError();
    private Font font = new Font("Consolas", 0, 18);
    private Integer frameSizeX = null;
    private Integer frameSizeY = null;
    private Integer spiltPaneDivLocation = null;
    private Integer spiltPaneDivLocationRight = null;
    private Integer scrollPositionInputY = null;
    private Integer scrollPositionJsonataY = null;
    private Integer scrollPositionOutputY = null;

    public void load() {
        Properties storedSettings = new Properties();
        File settingsFile = SETTINGS_FILE;
        if (!settingsFile.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(settingsFile);){
            storedSettings.load(fis);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.example = storedSettings.getProperty("example") == null ? TesterUIJsonataExample.NONE : TesterUIJsonataExample.valueOf(storedSettings.getProperty("example"));
        if (storedSettings.getProperty("path.input") != null) {
            this.pathInput = Paths.get(storedSettings.getProperty("path.input"), new String[0]);
        }
        if (storedSettings.getProperty("path.jsonata") != null) {
            this.pathJsonata = Paths.get(storedSettings.getProperty("path.jsonata"), new String[0]);
        }
        if (storedSettings.getProperty("color.background.input") != null) {
            this.backgroundInput = new Color(Integer.parseInt(storedSettings.getProperty("color.background.input"), 16));
        }
        if (storedSettings.getProperty("color.background.jsonata") != null) {
            this.backgroundJsonata = new Color(Integer.parseInt(storedSettings.getProperty("color.background.jsonata"), 16));
        }
        if (storedSettings.getProperty("color.background.output") != null) {
            this.backgroundOutput = new Color(Integer.parseInt(storedSettings.getProperty("color.background.output"), 16));
        }
        if (storedSettings.getProperty("color.background.error") != null) {
            this.backgroundError = new Color(Integer.parseInt(storedSettings.getProperty("color.background.error"), 16));
        }
        if (storedSettings.getProperty("font") != null) {
            this.font = TesterUISettings.textToFont(storedSettings.getProperty("font"));
        }
        if (storedSettings.getProperty("frame.size.x") != null) {
            this.frameSizeX = Integer.parseInt(storedSettings.getProperty("frame.size.x"));
        }
        if (storedSettings.getProperty("frame.size.y") != null) {
            this.frameSizeY = Integer.parseInt(storedSettings.getProperty("frame.size.y"));
        }
        if (storedSettings.getProperty("frame.splitpanedivlocation") != null) {
            this.spiltPaneDivLocation = Integer.parseInt(storedSettings.getProperty("frame.splitpanedivlocation"));
        }
        if (storedSettings.getProperty("frame.splitpanedivlocation.right") != null) {
            this.spiltPaneDivLocationRight = Integer.parseInt(storedSettings.getProperty("frame.splitpanedivlocation.right"));
        }
        if (storedSettings.getProperty("frame.scrollposition.input.y") != null) {
            this.scrollPositionInputY = Integer.parseInt(storedSettings.getProperty("frame.scrollposition.input.y"));
        }
        if (storedSettings.getProperty("frame.scrollposition.jsonata.y") != null) {
            this.scrollPositionJsonataY = Integer.parseInt(storedSettings.getProperty("frame.scrollposition.jsonata.y"));
        }
        if (storedSettings.getProperty("frame.scrollposition.output.y") != null) {
            this.scrollPositionOutputY = Integer.parseInt(storedSettings.getProperty("frame.scrollposition.output.y"));
        }
    }

    public void store() {
        TesterUIProperties storedSettings = new TesterUIProperties(new Properties());
        this.ensureSettingsFolder();
        File settingsFile = SETTINGS_FILE;
        storedSettings.setProperty("example", this.example.name());
        storedSettings.setProperty("path.input", this.pathInput.toString());
        storedSettings.setProperty("path.jsonata", this.pathJsonata.toString());
        storedSettings.setProperty("color.background.input", Integer.toHexString(this.backgroundInput.getRGB()).substring(2).toUpperCase());
        storedSettings.setProperty("color.background.jsonata", Integer.toHexString(this.backgroundJsonata.getRGB()).substring(2).toUpperCase());
        storedSettings.setProperty("color.background.output", Integer.toHexString(this.backgroundOutput.getRGB()).substring(2).toUpperCase());
        storedSettings.setProperty("color.background.error", Integer.toHexString(this.backgroundError.getRGB()).substring(2).toUpperCase());
        storedSettings.setProperty("font", TesterUISettings.fontToText(this.font));
        storedSettings.setProperty("frame.size.x", Integer.toString(this.frameSizeX));
        storedSettings.setProperty("frame.size.y", Integer.toString(this.frameSizeY));
        storedSettings.setProperty("frame.splitpanedivlocation", Integer.toString(this.spiltPaneDivLocation));
        storedSettings.setProperty("frame.splitpanedivlocation.right", Integer.toString(this.spiltPaneDivLocationRight));
        storedSettings.setProperty("frame.scrollposition.input.y", Integer.toString(this.scrollPositionInputY));
        storedSettings.setProperty("frame.scrollposition.jsonata.y", Integer.toString(this.scrollPositionJsonataY));
        storedSettings.setProperty("frame.scrollposition.output.y", Integer.toString(this.scrollPositionOutputY));
        try (FileOutputStream fos = new FileOutputStream(settingsFile);){
            storedSettings.store(fos, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static String fontToText(Font in) {
        return in.getFamily() + "," + in.getFontName() + "," + in.getStyle() + "," + in.getSize();
    }

    public static Font textToFont(String in) {
        String[] args = in.split(",");
        return new Font(args[1], Integer.parseInt(args[2]), Integer.parseInt(args[3]));
    }

    public void ensureSettingsFolder() {
        File settingsFolder = SETTINGS_FOLDER;
        if (!settingsFolder.exists() && !settingsFolder.mkdirs()) {
            new RuntimeException("Could not create folder " + settingsFolder.getAbsolutePath()).printStackTrace();
            return;
        }
    }

    public TesterUIJsonataExample getExample() {
        return this.example;
    }

    public void setExample(TesterUIJsonataExample example) {
        this.example = example;
    }

    public Path getPathInput() {
        return this.pathInput;
    }

    public void setPathInput(Path path) {
        this.pathInput = path;
    }

    public Path getPathJsonata() {
        return this.pathJsonata;
    }

    public void setPathJsonata(Path path) {
        this.pathJsonata = path;
    }

    public Color getBackgroundInput() {
        return this.backgroundInput;
    }

    public void setBackgroundInput(Color backgroundInput) {
        this.backgroundInput = backgroundInput;
    }

    public Color getBackgroundJsonata() {
        return this.backgroundJsonata;
    }

    public void setBackgroundJsonata(Color backgroundJsonata) {
        this.backgroundJsonata = backgroundJsonata;
    }

    public Color getBackgroundOutput() {
        return this.backgroundOutput;
    }

    public void setBackgroundOutput(Color backgroundOutput) {
        this.backgroundOutput = backgroundOutput;
    }

    public Color getBackgroundError() {
        return this.backgroundError;
    }

    public void setBackgroundError(Color backgroundError) {
        this.backgroundError = backgroundError;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Integer getFrameSizeX() {
        return this.frameSizeX;
    }

    public void setFrameSizeX(Integer frameSizeX) {
        this.frameSizeX = frameSizeX;
    }

    public Integer getFrameSizeY() {
        return this.frameSizeY;
    }

    public void setFrameSizeY(Integer frameSizeY) {
        this.frameSizeY = frameSizeY;
    }

    public Integer getSpiltPaneDivLocation() {
        return this.spiltPaneDivLocation;
    }

    public void setSpiltPaneDivLocation(Integer spiltPaneDivLocation) {
        this.spiltPaneDivLocation = spiltPaneDivLocation;
    }

    public Integer getSpiltPaneDivLocationRight() {
        return this.spiltPaneDivLocationRight;
    }

    public void setSpiltPaneDivLocationRight(Integer spiltPaneDivLocationRight) {
        this.spiltPaneDivLocationRight = spiltPaneDivLocationRight;
    }

    public Integer getScrollPositionInputY() {
        return this.scrollPositionInputY;
    }

    public void setScrollPositionInputY(Integer scrollPositionInputY) {
        this.scrollPositionInputY = scrollPositionInputY;
    }

    public Integer getScrollPositionJsonataY() {
        return this.scrollPositionJsonataY;
    }

    public void setScrollPositionJsonataY(Integer scrollPositionJsonataY) {
        this.scrollPositionJsonataY = scrollPositionJsonataY;
    }

    public Integer getScrollPositionOutputY() {
        return this.scrollPositionOutputY;
    }

    public void setScrollPositionOutputY(Integer scrollPositionOutputY) {
        this.scrollPositionOutputY = scrollPositionOutputY;
    }

    static {
        try {
            DEFAULT_PATH_INPUT = Paths.get("src/test/resources/exerciser/address.json", new String[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_PATH_JSONATA = Paths.get("src/test/resources/exerciser/addressExpression.jsonata", new String[0]);
    }
}

