/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java;

import com.api.jsonata4java.BindingType;
import com.api.jsonata4java.expressions.Expressions;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

public class Binding
implements Serializable {
    private static final long serialVersionUID = -7183986949584334476L;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    String _varname = null;
    MappingExpressionParser.ExprContext _expr = null;
    DeclaredFunction _fct = null;
    BindingType _type;

    public Binding(String expression) throws ParseException, IOException {
        Expressions exprCTX = Expressions.parse(expression);
        ParseTree tree = exprCTX.getTree();
        try {
            if (tree instanceof MappingExpressionParser.Var_assignContext) {
                MappingExpressionParser.ExprContext expr;
                MappingExpressionParser.Var_assignContext ctx = (MappingExpressionParser.Var_assignContext)tree;
                this._varname = ctx.VAR_ID().getText();
                this._expr = expr = ctx.expr();
                this._type = BindingType.VARIABLE;
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Cannot transform expression to a variable assignment");
        }
    }

    public Binding(String varName, JsonNode value) throws ParseException {
        if (!((String)varName).startsWith("$")) {
            varName = "$" + (String)varName;
        }
        this._expr = new MappingExpressionParser.StringContext(new MappingExpressionParser.ExprContext());
        CommonToken token = null;
        MappingExpressionParser.ExprContext ctx = new MappingExpressionParser.ExprContext();
        ctx.children = new ArrayList();
        switch (value.getNodeType()) {
            case OBJECT: {
                try {
                    String strValue = objectMapper.writeValueAsString(value);
                    Expressions exprCTX = Expressions.parse(strValue);
                    ParseTree tree = exprCTX.getTree();
                    this._expr = (MappingExpressionParser.ExprContext)tree;
                    break;
                }
                catch (IOException e) {
                    throw new ParseException("ERROR IN BINDINGS: " + e.getLocalizedMessage());
                }
            }
            case ARRAY: {
                try {
                    String strValue = objectMapper.writeValueAsString(value);
                    Expressions exprCTX = Expressions.parse(strValue);
                    ParseTree tree = exprCTX.getTree();
                    this._expr = (MappingExpressionParser.ExprContext)tree;
                    break;
                }
                catch (IOException e) {
                    throw new ParseException("ERROR IN BINDINGS: " + e.getLocalizedMessage());
                }
            }
            case BINARY: 
            case POJO: {
                break;
            }
            case BOOLEAN: {
                token = value.asBoolean() ? CommonTokenFactory.DEFAULT.create(13, value.asText()) : CommonTokenFactory.DEFAULT.create(14, value.asText());
                TerminalNodeImpl tn = new TerminalNodeImpl(token);
                MappingExpressionParser.BooleanContext bc = new MappingExpressionParser.BooleanContext(ctx);
                bc.children.add(tn);
                this._expr.addChild(bc);
                break;
            }
            case MISSING: 
            case NULL: {
                token = CommonTokenFactory.DEFAULT.create(16, null);
                TerminalNodeImpl tn = new TerminalNodeImpl(token);
                MappingExpressionParser.NullContext nc = new MappingExpressionParser.NullContext(ctx);
                nc.children.add(tn);
                this._expr.addChild(nc);
                break;
            }
            case NUMBER: {
                token = CommonTokenFactory.DEFAULT.create(24, value.asText());
                TerminalNodeImpl tn = new TerminalNodeImpl(token);
                MappingExpressionParser.NumberContext nc = new MappingExpressionParser.NumberContext(ctx);
                nc.children.add(tn);
                this._expr.addChild(nc);
                break;
            }
            default: {
                token = CommonTokenFactory.DEFAULT.create(15, value.asText());
                TerminalNodeImpl tn = new TerminalNodeImpl(token);
                MappingExpressionParser.StringContext sc = new MappingExpressionParser.StringContext(ctx);
                sc.children.add(tn);
                this._expr.addChild(sc);
                break;
            }
        }
        this._type = BindingType.VARIABLE;
        this._varname = varName;
    }

    public Binding(String varName, String expression) throws ParseException, IOException {
        if (!((String)varName).startsWith("$")) {
            varName = "$" + (String)varName;
        }
        Expressions exprCTX = Expressions.parse(expression);
        ParseTree tree = exprCTX.getTree();
        try {
            if (tree instanceof MappingExpressionParser.Function_declContext) {
                DeclaredFunction fct;
                MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)tree;
                MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
                MappingExpressionParser.ExprListContext exprList = fctDeclCtx.exprList();
                this._fct = fct = new DeclaredFunction(varList, exprList);
                this._type = BindingType.FUNCTION;
                this._varname = varName;
            } else if (tree instanceof MappingExpressionParser.Var_assignContext) {
                MappingExpressionParser.ExprContext expr;
                MappingExpressionParser.Var_assignContext ctx = (MappingExpressionParser.Var_assignContext)tree;
                this._varname = ctx.VAR_ID().getText();
                this._expr = expr = ctx.expr();
                this._type = BindingType.VARIABLE;
                this._varname = varName;
            } else if (tree instanceof MappingExpressionParser.IdContext) {
                this._expr = new MappingExpressionParser.StringContext(new MappingExpressionParser.ExprContext());
                this._expr.addChild((TerminalNode)tree.getChild(0));
                this._type = BindingType.VARIABLE;
                this._varname = varName;
            } else {
                this._expr = (MappingExpressionParser.ExprContext)tree;
                this._type = BindingType.VARIABLE;
                this._varname = varName;
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Cannot transform expression to a function declaration");
        }
    }

    public String getVarName() {
        return this._varname;
    }

    public DeclaredFunction getFunction() {
        return this._fct;
    }

    public MappingExpressionParser.ExprContext getExpression() {
        return this._expr;
    }

    public BindingType getType() {
        return this._type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this._type) {
            case VARIABLE: {
                sb.append(this._varname);
                sb.append("=");
                sb.append(this._expr.getText());
                break;
            }
            case FUNCTION: {
                sb.append("function(");
                List<TerminalNode> varList = this._fct.getVariables();
                int count = 0;
                for (TerminalNode tn : varList) {
                    if (count > 0) {
                        sb.append(",");
                    }
                    sb.append(tn.getText());
                    ++count;
                }
                sb.append("){");
                MappingExpressionParser.ExprListContext expListCtx = this._fct.getExpressionList();
                sb.append(expListCtx.getText());
                sb.append("}");
                break;
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            Binding test = new Binding("$x:=4");
            System.out.println(test);
            test = new Binding("addx", "function($a,$b){$a+$b}");
            System.out.println(test);
        }
        catch (ParseException | IOException e) {
            e.printStackTrace();
        }
    }
}

