/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.Iterator;

public class MinFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$min");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$min");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$min");
    public static final String ERR_ARG_TYPE = String.format("Argument 1 of function \"%s\" must be an array of \"number\"", "$min");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ArrayNode items;
        JsonNode result = null;
        JsonNode argArray = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = MinFunction.getArgumentCount(ctx);
        if (useContext) {
            argArray = FunctionUtils.getContextVariable(expressionVisitor);
            if (argArray != null && !argArray.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG2BADTYPE);
        if (!useContext) {
            argArray = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argArray == null) {
            return null;
        }
        if (!useContext) {
            FunctionUtils.validateArguments(ERR_ARG_TYPE, expressionVisitor, ctx, 0, this.getSignature());
        }
        if (!argArray.isArray()) {
            argArray = ExpressionsVisitor.ensureArray(argArray);
        }
        if ((items = (ArrayNode)argArray).size() <= 0) return null;
        JsonNode min = null;
        Iterator<JsonNode> iterator = items.iterator();
        while (iterator.hasNext()) {
            JsonNode item = iterator.next();
            if (!item.isNumber()) throw new EvaluateRuntimeException(ERR_ARG_TYPE);
            if (min != null && !(item.asDouble() < min.asDouble())) continue;
            min = item;
        }
        return min;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<a<n>:n>";
    }
}

