/*
 * Decompiled with CFR 0.152.
 */
package com.flaptor.indextank.apiclient;

import com.flaptor.indextank.apiclient.ApiClient;
import com.flaptor.indextank.apiclient.Base64;
import com.flaptor.indextank.apiclient.IndexAlreadyExistsException;
import com.flaptor.indextank.apiclient.IndexDoesNotExistException;
import com.flaptor.indextank.apiclient.InvalidSyntaxException;
import com.flaptor.indextank.apiclient.MaximumIndexesExceededException;
import com.flaptor.indextank.apiclient.UnexpectedCodeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexTankClient
implements ApiClient {
    private static final String GET_METHOD = "GET";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final String SEARCH_URL = "/search";
    private static final String DOCS_URL = "/docs";
    private static final String CATEGORIES_URL = "/docs/categories";
    private static final String VARIABLES_URL = "/docs/variables";
    private static final String PROMOTE_URL = "/promote";
    private static final String FUNCTIONS_URL = "/functions";
    private static final DateFormat ISO8601_PARSER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
    private final String apiUrl;
    private final String privatePass;

    private static Object callAPI(String method, String urlString, ParameterMap params, String privatePass) throws IOException, HttpCodeException {
        return IndexTankClient.callAPI(method, urlString, params, (String)null, privatePass);
    }

    private static Object callAPI(String method, String urlString, String privatePass) throws IOException, HttpCodeException {
        return IndexTankClient.callAPI(method, urlString, null, (String)null, privatePass);
    }

    private static Object callAPI(String method, String urlString, ParameterMap params, Map<String, Object> data, String privatePass) throws IOException, HttpCodeException {
        return IndexTankClient.callAPI(method, urlString, params, data == null ? null : JSONObject.toJSONString(data), privatePass);
    }

    private static Object callAPI(String method, String urlString, ParameterMap params, List<Map<String, Object>> data, String privatePass) throws IOException, HttpCodeException {
        return IndexTankClient.callAPI(method, urlString, params, data == null ? null : JSONArray.toJSONString(data), privatePass);
    }

    private static Object callAPI(String method, String urlString, ParameterMap params, String data, String privatePass) throws IOException, HttpCodeException {
        String line;
        BufferedReader in;
        if (params != null && !params.isEmpty()) {
            urlString = urlString + "?" + IndexTankClient.paramsToQueryString(params);
        }
        URL url = new URL(urlString);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setInstanceFollowRedirects(false);
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes(privatePass.getBytes()));
        urlConnection.setRequestMethod(method);
        if (method.equals(PUT_METHOD) && data != null) {
            OutputStreamWriter out = new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8");
            out.write(data);
            out.close();
        }
        int responseCode = urlConnection.getResponseCode();
        StringBuffer response = new StringBuffer();
        if (responseCode >= 400) {
            InputStream errorStream = urlConnection.getErrorStream();
            if (errorStream != null) {
                String line2;
                in = new BufferedReader(new InputStreamReader(errorStream));
                while ((line2 = in.readLine()) != null) {
                    response.append(line2);
                }
            }
            throw new HttpCodeException(responseCode, response.toString());
        }
        in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        while ((line = in.readLine()) != null) {
            response.append(line);
        }
        if (responseCode != 200 && responseCode != 201) {
            throw new HttpCodeException(responseCode, response.toString());
        }
        in.close();
        String jsonResponse = response.toString();
        if (!jsonResponse.isEmpty()) {
            JSONParser parser = new JSONParser();
            try {
                return parser.parse(jsonResponse);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static String paramsToQueryString(ParameterMap params) {
        StringBuilder sb = new StringBuilder();
        for (String key : params.keyset()) {
            for (String value : params.get(key)) {
                try {
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                    sb.append("=");
                    sb.append(URLEncoder.encode(value, "UTF-8"));
                    sb.append("&");
                }
                catch (UnsupportedEncodingException e) {}
            }
        }
        return sb.toString();
    }

    public IndexTankClient(String apiUrl) {
        this.apiUrl = IndexTankClient.appendTrailingSlash(apiUrl);
        try {
            this.privatePass = new URL(apiUrl).getUserInfo();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Deprecated
    public IndexTankClient(String apiUrl, String privatePass) {
        this.apiUrl = IndexTankClient.appendTrailingSlash(apiUrl);
        this.privatePass = privatePass;
    }

    private static String appendTrailingSlash(String apiUrl) {
        if (!apiUrl.endsWith("/")) {
            apiUrl = apiUrl + "/";
        }
        return apiUrl;
    }

    @Override
    public Index getIndex(String indexName) {
        return new Index(this.getIndexUrl(indexName));
    }

    @Override
    public Index createIndex(String indexName) throws IOException, IndexAlreadyExistsException, MaximumIndexesExceededException {
        return this.createIndex(indexName, null);
    }

    @Override
    public Index createIndex(String indexName, IndexConfiguration conf) throws IOException, IndexAlreadyExistsException, MaximumIndexesExceededException {
        Index index = this.getIndex(indexName);
        index.create(conf);
        return index;
    }

    @Override
    public void deleteIndex(String indexName) throws IOException, IndexDoesNotExistException {
        this.getIndex(indexName).delete();
    }

    public List<Index> listIndexes() throws IOException {
        try {
            ArrayList<Index> result = new ArrayList<Index>();
            Map responseMap = (Map)IndexTankClient.callAPI(GET_METHOD, this.getIndexesUrl(), this.privatePass);
            for (Map.Entry entry : responseMap.entrySet()) {
                result.add(new Index(this.getIndexUrl((String)entry.getKey()), (Map)entry.getValue()));
            }
            return result;
        }
        catch (HttpCodeException e) {
            throw new UnexpectedCodeException(e);
        }
    }

    private String getIndexUrl(String indexName) {
        return this.getIndexesUrl() + IndexTankClient.encodeIndexName(indexName);
    }

    private static String encodeIndexName(String indexName) {
        URI url;
        try {
            url = new URI("http", "none.com", "/" + indexName, null);
        }
        catch (URISyntaxException e) {
            return indexName;
        }
        return url.getRawPath().substring(1);
    }

    private String getIndexesUrl() {
        String indexesUrl = this.apiUrl + "v1/indexes/";
        return indexesUrl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterMap {
        private Map<String, List<String>> innerMap = new HashMap<String, List<String>>();

        ParameterMap() {
        }

        public Set<String> keyset() {
            return this.innerMap.keySet();
        }

        public void addAll(String key, Iterable<String> newvalues) {
            List<String> values = this.innerMap.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.innerMap.put(key, values);
            }
            for (String newvalue : newvalues) {
                values.add(newvalue);
            }
        }

        public boolean isEmpty() {
            return this.innerMap.isEmpty();
        }

        void add(String key, String value) {
            List<String> values = this.innerMap.get(key);
            if (values != null) {
                values.add(value);
            } else {
                this.put(key, value);
            }
        }

        void put(String key, String value) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.innerMap.put(key, values);
        }

        String getFirst(String key) {
            List<String> values = this.innerMap.get(key);
            if (values != null && values.size() > 0) {
                return values.get(0);
            }
            return null;
        }

        List<String> get(String key) {
            return this.innerMap.get(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Index
    implements com.flaptor.indextank.apiclient.Index {
        private final String indexUrl;
        private Map<String, Object> metadata;

        private Index(String indexUrl) {
            this.indexUrl = indexUrl;
        }

        private Index(String indexUrl, Map<String, Object> metadata) {
            this.indexUrl = indexUrl;
            this.metadata = metadata;
        }

        @Override
        public SearchResults search(String query) throws IOException, InvalidSyntaxException {
            return this.search(Query.forString(query));
        }

        @Override
        public SearchResults search(Query query) throws IOException, InvalidSyntaxException {
            ParameterMap params = query.toParameterMap();
            try {
                return new SearchResults((Map)IndexTankClient.callAPI(IndexTankClient.GET_METHOD, this.indexUrl + IndexTankClient.SEARCH_URL, params, IndexTankClient.this.privatePass));
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 400) {
                    throw new InvalidSyntaxException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void deleteBySearch(String query) throws IOException, IndexDoesNotExistException, InvalidSyntaxException {
            this.deleteBySearch(Query.forString(query));
        }

        @Override
        public void deleteBySearch(Query query) throws IOException, IndexDoesNotExistException, InvalidSyntaxException {
            ParameterMap params = query.toParameterMap();
            try {
                IndexTankClient.callAPI(IndexTankClient.DELETE_METHOD, this.indexUrl + IndexTankClient.SEARCH_URL, params, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 400) {
                    throw new InvalidSyntaxException(e);
                }
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void create() throws IOException, IndexAlreadyExistsException, MaximumIndexesExceededException {
            this.create(null);
        }

        @Override
        public void create(IndexConfiguration conf) throws IOException, IndexAlreadyExistsException, MaximumIndexesExceededException {
            if (this.exists()) {
                throw new IndexAlreadyExistsException("Index already exists");
            }
            Map<String, Object> data = null;
            if (conf != null) {
                data = conf.toConfigurationMap();
            }
            try {
                IndexTankClient.callAPI(IndexTankClient.PUT_METHOD, this.indexUrl, null, data, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 204) {
                    throw new IndexAlreadyExistsException(e);
                }
                if (e.getHttpCode() == 409) {
                    throw new MaximumIndexesExceededException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void update(IndexConfiguration conf) throws IndexDoesNotExistException, IOException {
            if (conf == null) {
                throw new IllegalArgumentException("Index configuration must not be null");
            }
            Map<String, Object> data = conf.toConfigurationMap();
            if (data.size() == 0) {
                throw new IllegalArgumentException("Index configuration is empty.");
            }
            if (!this.exists()) {
                throw new IndexDoesNotExistException("Index does not exist");
            }
            try {
                IndexTankClient.callAPI(IndexTankClient.PUT_METHOD, this.indexUrl, null, data, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 204) {
                    this.refreshMetadata();
                    return;
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void delete() throws IOException, IndexDoesNotExistException {
            try {
                IndexTankClient.callAPI(IndexTankClient.DELETE_METHOD, this.indexUrl, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public BatchResults addDocuments(Iterable<Document> documents) throws IOException, IndexDoesNotExistException {
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            for (Document document : documents) {
                Map<String, Object> documentMap = document.toDocumentMap();
                data.add(documentMap);
            }
            try {
                List results = (List)IndexTankClient.callAPI(IndexTankClient.PUT_METHOD, this.indexUrl + IndexTankClient.DOCS_URL, null, data, IndexTankClient.this.privatePass);
                ArrayList<Boolean> addeds = new ArrayList<Boolean>(results.size());
                ArrayList<String> errors = new ArrayList<String>(results.size());
                boolean hasErrors = false;
                for (int i = 0; i < results.size(); ++i) {
                    Map result = (Map)results.get(i);
                    Boolean added = (Boolean)result.get("added");
                    addeds.add(i, added);
                    if (added.booleanValue()) continue;
                    hasErrors = true;
                    errors.add(i, (String)result.get("error"));
                }
                ArrayList<Document> documentsList = new ArrayList<Document>();
                for (Document document : documents) {
                    documentsList.add(document);
                }
                return new BatchResults((List<Boolean>)addeds, (List<String>)errors, (List<Document>)documentsList, hasErrors);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 400) {
                    throw new IllegalArgumentException(e);
                }
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void addDocument(String documentId, Map<String, String> fields) throws IOException, IndexDoesNotExistException {
            this.addDocument(documentId, fields, null);
        }

        @Override
        public void addDocument(String documentId, Map<String, String> fields, Map<Integer, Float> variables) throws IOException, IndexDoesNotExistException {
            this.addDocument(documentId, fields, variables, null);
        }

        @Override
        public void addDocument(String documentId, Map<String, String> fields, Map<Integer, Float> variables, Map<String, String> categories) throws IOException, IndexDoesNotExistException {
            if (null == documentId) {
                throw new IllegalArgumentException("documentId can not be null.");
            }
            if (documentId.getBytes("UTF-8").length > 1024) {
                throw new IllegalArgumentException("documentId can not be longer than 1024 bytes when UTF-8 encoded.");
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("docid", documentId);
            data.put("fields", fields);
            if (variables != null) {
                data.put("variables", variables);
            }
            if (categories != null) {
                data.put("categories", categories);
            }
            try {
                IndexTankClient.callAPI(IndexTankClient.PUT_METHOD, this.indexUrl + IndexTankClient.DOCS_URL, null, data, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 400) {
                    throw new UnexpectedCodeException(e);
                }
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void deleteDocument(String documentId) throws IOException, IndexDoesNotExistException {
            if (null == documentId) {
                throw new IllegalArgumentException("documentId can not be null");
            }
            ParameterMap params = new ParameterMap();
            params.put("docid", documentId);
            try {
                IndexTankClient.callAPI(IndexTankClient.DELETE_METHOD, this.indexUrl + IndexTankClient.DOCS_URL, params, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public BulkDeleteResults deleteDocuments(Iterable<String> documentIds) throws IOException, IndexDoesNotExistException {
            if (null == documentIds) {
                throw new IllegalArgumentException("documentIds can not be null");
            }
            ParameterMap params = new ParameterMap();
            params.addAll("docid", documentIds);
            try {
                List results = (List)IndexTankClient.callAPI(IndexTankClient.DELETE_METHOD, this.indexUrl + IndexTankClient.DOCS_URL, params, IndexTankClient.this.privatePass);
                ArrayList<Boolean> deleted = new ArrayList<Boolean>(results.size());
                ArrayList<String> errors = new ArrayList<String>(results.size());
                boolean hasErrors = false;
                for (int i = 0; i < results.size(); ++i) {
                    Map result = (Map)results.get(i);
                    Boolean wasDeleted = (Boolean)result.get("deleted");
                    deleted.add(i, wasDeleted);
                    if (wasDeleted.booleanValue()) continue;
                    hasErrors = true;
                    errors.add(i, (String)result.get("error"));
                }
                ArrayList<String> docidList = new ArrayList<String>();
                for (String docid : documentIds) {
                    docidList.add(docid);
                }
                return new BulkDeleteResults((List<Boolean>)deleted, (List<String>)errors, (List<String>)docidList, hasErrors);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void updateVariables(String documentId, Map<Integer, Float> variables) throws IOException, IndexDoesNotExistException {
            if (null == documentId) {
                throw new IllegalArgumentException("documentId can not be null");
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("docid", documentId);
            data.put("variables", variables);
            try {
                IndexTankClient.callAPI(IndexTankClient.PUT_METHOD, this.indexUrl + IndexTankClient.VARIABLES_URL, null, data, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void updateCategories(String documentId, Map<String, String> variables) throws IOException, IndexDoesNotExistException {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("docid", documentId);
            data.put("categories", variables);
            try {
                IndexTankClient.callAPI(IndexTankClient.PUT_METHOD, this.indexUrl + IndexTankClient.CATEGORIES_URL, null, data, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void promote(String documentId, String query) throws IOException, IndexDoesNotExistException {
            if (null == documentId) {
                throw new IllegalArgumentException("documentId can not be null");
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("docid", documentId);
            data.put("query", query);
            try {
                IndexTankClient.callAPI(IndexTankClient.PUT_METHOD, this.indexUrl + IndexTankClient.PROMOTE_URL, null, data, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void addFunction(Integer functionIndex, String definition) throws IOException, IndexDoesNotExistException, InvalidSyntaxException {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("definition", definition);
            try {
                IndexTankClient.callAPI(IndexTankClient.PUT_METHOD, this.indexUrl + IndexTankClient.FUNCTIONS_URL + "/" + functionIndex, null, data, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                if (e.getHttpCode() == 400) {
                    throw new InvalidSyntaxException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public void deleteFunction(Integer functionIndex) throws IOException, IndexDoesNotExistException {
            try {
                IndexTankClient.callAPI(IndexTankClient.DELETE_METHOD, this.indexUrl + IndexTankClient.FUNCTIONS_URL + "/" + functionIndex, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public Map<String, String> listFunctions() throws IndexDoesNotExistException, IOException {
            try {
                Map responseMap = (Map)IndexTankClient.callAPI(IndexTankClient.GET_METHOD, this.indexUrl + IndexTankClient.FUNCTIONS_URL, IndexTankClient.this.privatePass);
                HashMap<String, String> result = new HashMap<String, String>();
                for (Map.Entry entry : responseMap.entrySet()) {
                    result.put((String)entry.getKey(), (String)entry.getValue());
                }
                return result;
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public boolean exists() throws IOException {
            try {
                this.refreshMetadata();
                return true;
            }
            catch (IndexDoesNotExistException e) {
                return false;
            }
        }

        @Override
        public boolean hasStarted() throws IOException, IndexDoesNotExistException {
            this.refreshMetadata();
            return (Boolean)this.getMetadata().get("started");
        }

        @Override
        public String getStatus() throws IOException, IndexDoesNotExistException {
            return (String)this.getMetadata().get("status");
        }

        @Override
        public String getCode() throws IOException, IndexDoesNotExistException {
            return (String)this.getMetadata().get("code");
        }

        @Override
        public Date getCreationTime() throws IOException, IndexDoesNotExistException {
            try {
                return ISO8601_PARSER.parse((String)this.getMetadata().get("creation_time"));
            }
            catch (java.text.ParseException e) {
                return null;
            }
        }

        @Override
        public boolean isPublicSearchEnabled() throws IOException, IndexDoesNotExistException {
            return (Boolean)this.getMetadata().get("public_search");
        }

        @Override
        public void refreshMetadata() throws IOException, IndexDoesNotExistException {
            try {
                this.metadata = (Map)IndexTankClient.callAPI(IndexTankClient.GET_METHOD, this.indexUrl, IndexTankClient.this.privatePass);
            }
            catch (HttpCodeException e) {
                if (e.getHttpCode() == 404) {
                    throw new IndexDoesNotExistException(e);
                }
                throw new UnexpectedCodeException(e);
            }
        }

        @Override
        public Map<String, Object> getMetadata() throws IOException, IndexDoesNotExistException {
            if (this.metadata == null) {
                this.refreshMetadata();
            }
            return this.metadata;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndexConfiguration {
        protected Boolean publicSearch;

        public IndexConfiguration enablePublicSearch(Boolean publicSearchEnabled) {
            this.publicSearch = publicSearchEnabled;
            return this;
        }

        protected Map<String, Object> toConfigurationMap() {
            HashMap<String, Object> conf = new HashMap<String, Object>();
            if (this.publicSearch != null) {
                conf.put("public_search", this.publicSearch);
            }
            return conf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Query {
        protected Integer start;
        protected Integer length;
        protected Integer scoringFunction;
        protected List<String> snippetFields;
        protected List<String> fetchFields;
        protected Map<String, List<String>> categoryFilters;
        protected List<Range> functionFilters;
        protected List<Range> documentVariableFilters;
        protected Map<Integer, Float> queryVariables;
        protected String queryString;

        public static Query forString(String query) {
            return new Query(query);
        }

        protected Query(String query) {
            this.queryString = query;
        }

        public Query withStart(Integer start) {
            this.start = start;
            return this;
        }

        public Query withLength(Integer length) {
            this.length = length;
            return this;
        }

        public Query withScoringFunction(Integer scoringFunction) {
            this.scoringFunction = scoringFunction;
            return this;
        }

        public Query withSnippetFields(List<String> snippetFields) {
            if (snippetFields == null) {
                throw new NullPointerException("snippetFields must be non-null");
            }
            if (this.snippetFields == null) {
                this.snippetFields = new ArrayList<String>();
            }
            this.snippetFields.addAll(snippetFields);
            return this;
        }

        public Query withSnippetFields(String ... snippetFields) {
            return this.withSnippetFields(Arrays.asList(snippetFields));
        }

        public Query withFetchFields(List<String> fetchFields) {
            if (fetchFields == null) {
                throw new NullPointerException("fetchFields must be non-null");
            }
            if (this.fetchFields == null) {
                this.fetchFields = new ArrayList<String>();
            }
            this.fetchFields.addAll(fetchFields);
            return this;
        }

        public Query withFetchFields(String ... fetchFields) {
            return this.withFetchFields(Arrays.asList(fetchFields));
        }

        public Query withDocumentVariableFilter(int variableIndex, double floor, double ceil) {
            if (this.documentVariableFilters == null) {
                this.documentVariableFilters = new ArrayList<Range>();
            }
            this.documentVariableFilters.add(new Range(variableIndex, floor, ceil));
            return this;
        }

        public Query withFunctionFilter(int functionIndex, double floor, double ceil) {
            if (this.functionFilters == null) {
                this.functionFilters = new ArrayList<Range>();
            }
            this.functionFilters.add(new Range(functionIndex, floor, ceil));
            return this;
        }

        public Query withCategoryFilters(Map<String, List<String>> categoryFilters) {
            if (categoryFilters == null) {
                throw new NullPointerException("categoryFilters must be non-null");
            }
            if (this.categoryFilters == null && !categoryFilters.isEmpty()) {
                this.categoryFilters = new HashMap<String, List<String>>();
            }
            if (!categoryFilters.isEmpty()) {
                this.categoryFilters.putAll(categoryFilters);
            }
            return this;
        }

        public Query withQueryVariables(Map<Integer, Float> queryVariables) {
            if (queryVariables == null) {
                throw new NullPointerException("queryVariables must be non-null");
            }
            if (this.queryVariables == null && !queryVariables.isEmpty()) {
                this.queryVariables = new HashMap<Integer, Float>();
            }
            if (!queryVariables.isEmpty()) {
                this.queryVariables.putAll(queryVariables);
            }
            return this;
        }

        public Query withQueryVariable(Integer name, Float value) {
            if (name == null || value == null) {
                throw new NullPointerException("Both name and value must be non-null");
            }
            if (this.queryVariables == null) {
                this.queryVariables = new HashMap<Integer, Float>();
            }
            this.queryVariables.put(name, value);
            return this;
        }

        ParameterMap toParameterMap() {
            String param;
            String value;
            String key;
            ParameterMap params = new ParameterMap();
            if (this.start != null) {
                params.put("start", this.start.toString());
            }
            if (this.length != null) {
                params.put("len", this.length.toString());
            }
            if (this.scoringFunction != null) {
                params.put("function", this.scoringFunction.toString());
            }
            if (this.snippetFields != null) {
                params.put("snippet", Query.join(this.snippetFields, ","));
            }
            if (this.fetchFields != null) {
                params.put("fetch", Query.join(this.fetchFields, ","));
            }
            if (this.categoryFilters != null) {
                params.put("category_filters", JSONObject.toJSONString(this.categoryFilters));
            }
            if (this.documentVariableFilters != null) {
                for (Range range : this.documentVariableFilters) {
                    key = "filter_docvar" + range.id;
                    value = (range.floor == Double.NEGATIVE_INFINITY ? "*" : String.valueOf(range.floor)) + ":" + (range.ceil == Double.POSITIVE_INFINITY ? "*" : String.valueOf(range.ceil));
                    param = params.getFirst(key);
                    if (param == null) {
                        params.put(key, value);
                        continue;
                    }
                    params.put(key, param + "," + value);
                }
            }
            if (this.functionFilters != null) {
                for (Range range : this.functionFilters) {
                    key = "filter_function" + range.id;
                    value = (range.floor == Double.NEGATIVE_INFINITY ? "*" : String.valueOf(range.floor)) + ":" + (range.ceil == Double.POSITIVE_INFINITY ? "*" : String.valueOf(range.ceil));
                    param = params.getFirst(key);
                    if (param == null) {
                        params.put(key, value);
                        continue;
                    }
                    params.put(key, param + "," + value);
                }
            }
            if (this.queryVariables != null) {
                for (Map.Entry entry : this.queryVariables.entrySet()) {
                    params.put("var" + entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            params.put("q", this.queryString);
            return params;
        }

        public static String join(Iterable<String> s, String delimiter) {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iter = s.iterator();
            while (iter.hasNext()) {
                buffer.append(iter.next());
                if (!iter.hasNext()) continue;
                buffer.append(delimiter);
            }
            return buffer.toString();
        }

        public static class Range {
            protected int id;
            protected double floor;
            protected double ceil;

            public Range(int id, double floor, double ceil) {
                this.id = id;
                this.floor = floor;
                this.ceil = ceil;
            }

            public String getFilterDocvar() {
                return "filter_docvar" + this.id;
            }

            public String getFilterFunction() {
                return "filter_function" + this.id;
            }

            public String getValue() {
                return (this.floor == Double.NEGATIVE_INFINITY ? "*" : String.valueOf(this.floor)) + ":" + (this.ceil == Double.POSITIVE_INFINITY ? "*" : String.valueOf(this.ceil));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchResults {
        public final long matches;
        public final float searchTime;
        public final List<Map<String, Object>> results;
        public final Map<String, Map<String, Integer>> facets;

        public SearchResults(Map<String, Object> response) {
            this.matches = (Long)response.get("matches");
            this.searchTime = Float.valueOf((String)response.get("search_time")).floatValue();
            this.results = (List)response.get("results");
            this.facets = (Map)response.get("facets");
        }

        public String toString() {
            return "Matches: " + this.matches + "\nSearch Time: " + this.searchTime + "\nResults: " + this.results + "\nFacets: " + this.facets;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Document {
        private String id;
        private Map<String, String> fields;
        private Map<Integer, Float> variables;
        private Map<String, String> categories;

        public Map<String, Object> toDocumentMap() {
            HashMap<String, Object> documentMap = new HashMap<String, Object>();
            documentMap.put("docid", this.id);
            documentMap.put("fields", this.fields);
            if (this.variables != null) {
                documentMap.put("variables", this.variables);
            }
            if (this.categories != null) {
                documentMap.put("categories", this.categories);
            }
            return documentMap;
        }

        public Document(String id, Map<String, String> fields, Map<Integer, Float> variables, Map<String, String> categories) {
            if (id == null) {
                throw new IllegalArgumentException("Id cannot be null");
            }
            try {
                if (id.getBytes("UTF-8").length > 1024) {
                    throw new IllegalArgumentException("documentId can not be longer than 1024 bytes when UTF-8 encoded.");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Illegal documentId encoding.");
            }
            this.id = id;
            this.fields = fields;
            this.variables = variables;
            this.categories = categories;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BulkDeleteResults
    extends AbstractBatchResults<String> {
        public BulkDeleteResults(List<Boolean> results, List<String> errors, List<String> docids, boolean hasErrors) {
            super(results, errors, docids, hasErrors);
        }

        public String getDocid(int position) {
            return (String)this.getElement(position);
        }

        public Iterable<String> getFailedDocids() {
            return this.getFailedElements();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BatchResults
    extends AbstractBatchResults<Document> {
        public BatchResults(List<Boolean> results, List<String> errors, List<Document> documents, boolean hasErrors) {
            super(results, errors, documents, hasErrors);
        }

        public Document getDocument(int position) {
            return (Document)this.getElement(position);
        }

        public Iterable<Document> getFailedDocuments() {
            return this.getFailedElements();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractBatchResults<T> {
        private boolean hasErrors;
        private List<Boolean> results;
        private List<String> errors;
        private List<T> elements;

        public AbstractBatchResults(List<Boolean> results, List<String> errors, List<T> elements, boolean hasErrors) {
            this.results = results;
            this.errors = errors;
            this.hasErrors = hasErrors;
            this.elements = elements;
        }

        public boolean getResult(int position) {
            if (position >= this.results.size()) {
                throw new IllegalArgumentException("Position off bounds (" + position + ")");
            }
            return this.results.get(position);
        }

        public String getErrorMessage(int position) {
            if (position >= this.errors.size()) {
                throw new IllegalArgumentException("Position off bounds (" + position + ")");
            }
            return this.errors.get(position);
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        protected T getElement(int position) {
            return this.elements.get(position);
        }

        protected Iterable<T> getFailedElements() {
            return new Iterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return new Iterator<T>(){
                        private T next = this.computeNext();
                        private int position = 0;

                        private T computeNext() {
                            while (this.position < AbstractBatchResults.this.results.size() && ((Boolean)AbstractBatchResults.this.results.get(this.position)).booleanValue()) {
                                ++this.position;
                            }
                            if (this.position == AbstractBatchResults.this.results.size()) {
                                return null;
                            }
                            Object next = AbstractBatchResults.this.elements.get(this.position);
                            ++this.position;
                            return next;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public T next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object result = this.next;
                            this.next = this.computeNext();
                            return result;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }
                    };
                }
            };
        }
    }

    public static class HttpCodeException
    extends Exception {
        protected int httpCode;

        public HttpCodeException(int httpCode, String message) {
            super(message);
            this.httpCode = httpCode;
        }

        public int getHttpCode() {
            return this.httpCode;
        }
    }
}

