/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.analytics;

import com.jdroid.java.analytics.AnalyticsTracker;
import com.jdroid.java.collections.Lists;
import com.jdroid.java.utils.LoggerUtils;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public class AnalyticsSender<T extends AnalyticsTracker>
implements AnalyticsTracker {
    private static final Logger LOGGER = LoggerUtils.getLogger(AnalyticsSender.class);
    private List<T> trackers = Lists.newArrayList();

    @SafeVarargs
    public AnalyticsSender(T ... trackers) {
        this((List<T>)Lists.newArrayList(trackers));
    }

    public AnalyticsSender(List<T> trackers) {
        for (AnalyticsTracker tracker : trackers) {
            if (!tracker.isEnabled().booleanValue()) continue;
            this.trackers.add(tracker);
        }
    }

    @Override
    public Boolean isEnabled() {
        return null;
    }

    @Override
    public Executor getExecutor() {
        return null;
    }

    protected List<T> getTrackers() {
        return this.trackers;
    }

    public void addTracker(T tracker) {
        this.trackers.add(tracker);
    }

    protected void execute(TrackingCommand trackingCommand, Boolean logHandledExceptionEnabled) {
        for (AnalyticsTracker tracker : this.getTrackers()) {
            try {
                if (!tracker.isEnabled().booleanValue()) continue;
                tracker.getExecutor().execute(new TrackerRunnable(this, tracker, trackingCommand, logHandledExceptionEnabled));
            }
            catch (Exception e) {
                if (logHandledExceptionEnabled.booleanValue()) {
                    LoggerUtils.logHandledException(LOGGER, e);
                    continue;
                }
                LOGGER.error("Error when tracking.", (Throwable)e);
            }
        }
    }

    protected void execute(TrackingCommand trackingCommand) {
        this.execute(trackingCommand, true);
    }

    private static class TrackerRunnable
    implements Runnable {
        private T tracker;
        private TrackingCommand trackingCommand;
        private Boolean logHandledExceptionEnabled;
        final /* synthetic */ AnalyticsSender this$0;

        public TrackerRunnable(T tracker, TrackingCommand trackingCommand, Boolean logHandledExceptionEnabled) {
            this.this$0 = var1_1;
            this.tracker = tracker;
            this.trackingCommand = trackingCommand;
            this.logHandledExceptionEnabled = logHandledExceptionEnabled;
        }

        @Override
        public void run() {
            try {
                this.trackingCommand.track(this.tracker);
            }
            catch (Exception e) {
                if (this.logHandledExceptionEnabled.booleanValue()) {
                    LoggerUtils.logHandledException(LOGGER, e);
                }
                LOGGER.error("Error when tracking", (Throwable)e);
            }
        }
    }

    public abstract class TrackingCommand {
        protected abstract void track(T var1);
    }
}

