/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.collections;

import com.jdroid.java.collections.Iterators;
import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.ObjectArrays;
import java.util.ArrayList;
import java.util.Collection;

public class Iterables {
    public static int size(Iterable<?> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).size() : Iterators.size(iterable.iterator());
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        Collection<T> collection = Iterables.toCollection(iterable);
        T[] array = ObjectArrays.newArray(type, collection.size());
        return collection.toArray(array);
    }

    private static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : Lists.newArrayList(iterable.iterator());
    }
}

