/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.date;

import com.jdroid.java.date.DateConfiguration;
import com.jdroid.java.date.DayOfWeek;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.utils.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public abstract class DateUtils {
    public static void init() {
    }

    public static Date parse(String dateFormatted, String dateFormat) {
        return DateUtils.parse(dateFormatted, dateFormat, false);
    }

    public static Date parse(String dateFormatted, String dateFormat, boolean useUtc) {
        return DateUtils.parse(dateFormatted, new SimpleDateFormat(dateFormat), useUtc);
    }

    public static Date parse(String dateFormatted, SimpleDateFormat dateFormat) {
        return DateUtils.parse(dateFormatted, dateFormat, false);
    }

    public static Date parse(String dateFormatted, SimpleDateFormat dateFormat, boolean useUtc) {
        Date date = null;
        if (StringUtils.isNotEmpty(dateFormatted).booleanValue()) {
            try {
                if (useUtc) {
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                }
                date = dateFormat.parse(dateFormatted);
            }
            catch (ParseException e) {
                throw new UnexpectedException("Error parsing the dateFormatted: " + dateFormatted + " pattern: " + dateFormat.toPattern(), (Throwable)e);
            }
        }
        return date;
    }

    public static String format(Date date, String dateFormat) {
        return DateUtils.format(date, dateFormat, false);
    }

    public static String format(Date date, String dateFormat, boolean useUtc) {
        return DateUtils.format(date, new SimpleDateFormat(dateFormat), useUtc);
    }

    public static String format(Date date, DateFormat dateFormat) {
        return DateUtils.format(date, dateFormat, false);
    }

    public static String format(Date date, DateFormat dateFormat, boolean useUtc) {
        if (useUtc) {
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return date != null ? dateFormat.format(date) : null;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.format(date, DateFormat.getDateTimeInstance());
    }

    public static String formatDate(Date date) {
        return DateUtils.format(date, DateFormat.getDateInstance());
    }

    public static String formatTime(Date date) {
        return DateUtils.format(date, DateFormat.getTimeInstance(3));
    }

    public static Date getDate(int year, int monthOfYear, int dayOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, monthOfYear, dayOfMonth);
        DateUtils.truncateTime(calendar);
        return calendar.getTime();
    }

    public static Date getDate(Date date, Date time, Boolean is24Hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (time != null) {
            calendar.set(11, DateUtils.getHour(time, is24Hour));
            calendar.set(12, DateUtils.getMinute(time));
            calendar.set(13, 0);
        } else {
            DateUtils.truncateTime(calendar);
        }
        return calendar.getTime();
    }

    public static Date getDate(Date date, Date time) {
        return DateUtils.getDate(date, time, true);
    }

    public static Date getDate(long milliseconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(milliseconds);
        return calendar.getTime();
    }

    public static Date getTime(int hour, int minutes) {
        return DateUtils.getTime(hour, minutes, true);
    }

    public static Date getTime(int hour, int minutes, Boolean is24Hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(is24Hour != false ? 11 : 10, hour);
        calendar.set(12, minutes);
        calendar.set(13, 0);
        DateUtils.truncateDate(calendar);
        return calendar.getTime();
    }

    public static int getYear() {
        return DateUtils.getYear(DateUtils.now());
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth() {
        return DateUtils.getMonth(DateUtils.now());
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getHour(Date date, Boolean is24Hour) {
        return DateUtils.getHour(date, TimeZone.getDefault(), is24Hour);
    }

    public static int getHour(Date date, TimeZone timeZone, Boolean is24Hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(timeZone);
        return calendar.get(is24Hour != false ? 11 : 10);
    }

    public static int getMinute(Date date) {
        return DateUtils.getMinute(date, TimeZone.getDefault());
    }

    public static int getMinute(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(timeZone);
        return calendar.get(12);
    }

    public static int getSeconds(Date date) {
        return DateUtils.getSeconds(date, TimeZone.getDefault());
    }

    public static int getSeconds(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(timeZone);
        return calendar.get(13);
    }

    public static DayOfWeek getDayOfWeek() {
        return DateUtils.getDayOfWeek(DateUtils.now());
    }

    public static DayOfWeek getDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return DayOfWeek.findByNumber(dayOfWeek);
    }

    public static boolean isDateOnWeekend(Date date) {
        return DateUtils.getDayOfWeek(date).isWeekend();
    }

    public static Date setHour(Date date, int hours, Boolean is24Hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(is24Hour != false ? 11 : 10, hours);
        return calendar.getTime();
    }

    public static Date setMinutes(Date date, int minutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(12, minutes);
        return calendar.getTime();
    }

    public static Date addSeconds(Date date, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    public static Date addMinutes(Date date, int minutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, minutes);
        return calendar.getTime();
    }

    public static Date addHours(Date date, int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, hours);
        return calendar.getTime();
    }

    public static Date addDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date addMonths(Date date, int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Date addYears(Date date, int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        return calendar.getTime();
    }

    public static Date truncateDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.truncateDate(calendar);
        return calendar.getTime();
    }

    public static void truncateDate(Calendar calendar) {
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(1, 1980);
    }

    public static Date truncateTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.truncateTime(calendar);
        return calendar.getTime();
    }

    public static void truncateTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Date now() {
        return DateConfiguration.isFakeNow() != false ? DateConfiguration.getFakeNow() : new Date();
    }

    public static long nowMillis() {
        return DateConfiguration.isFakeNow() != false ? DateConfiguration.getFakeNow().getTime() : System.currentTimeMillis();
    }

    public static boolean isBetween(Date date, Date startDate, Date endDate) {
        return DateUtils.isBeforeEquals(startDate, date) && DateUtils.isAfterEquals(endDate, date);
    }

    public static boolean isBefore(Date date, Date dateToCompare) {
        return date.compareTo(dateToCompare) < 0;
    }

    public static boolean isBeforeEquals(Date date, Date dateToCompare) {
        return date.compareTo(dateToCompare) <= 0;
    }

    public static boolean isAfterEquals(Date date, Date dateToCompare) {
        return date.compareTo(dateToCompare) >= 0;
    }

    public static boolean isAfter(Date date, Date dateToCompare) {
        return date.compareTo(dateToCompare) > 0;
    }

    public static boolean periodsOverlap(Date startDate1, Date endDate1, Date startDate2, Date endDate2) {
        return !(!startDate1.before(endDate2) && !startDate1.equals(endDate2) || !endDate1.after(startDate2) && !endDate1.equals(startDate2));
    }

    public static boolean containsPeriod(Date startDate1, Date endDate1, Date startDate2, Date endDate2) {
        return DateUtils.isBeforeEquals(startDate1, startDate2) && DateUtils.isAfterEquals(endDate1, endDate2);
    }

    public static Boolean isToday(Date date) {
        return DateUtils.truncateTime(date).equals(DateUtils.today());
    }

    public static Boolean isToday(Long timestamp) {
        return DateUtils.isToday(DateUtils.getDate(timestamp));
    }

    public static Boolean isYesterdayOrPrevious(Date date) {
        return DateUtils.isYesterdayOrPrevious(date.getTime());
    }

    public static Boolean isYesterdayOrPrevious(Long timestamp) {
        return timestamp < DateUtils.today().getTime();
    }

    public static Boolean isSameDay(Date a, Date b) {
        return DateUtils.truncateTime(a).equals(DateUtils.truncateTime(b));
    }

    public static Date tomorrow() {
        return DateUtils.addDays(DateUtils.today(), 1);
    }

    public static Date today() {
        return DateUtils.truncateTime(DateUtils.now());
    }

    public static Date yesterday() {
        return DateUtils.addDays(DateUtils.today(), -1);
    }

    public static Date monthsAway(int months) {
        return DateUtils.addMonths(DateUtils.today(), months);
    }

    public static Date oneMonthInFuture() {
        return DateUtils.monthsAway(1);
    }

    public static Date oneMonthInPast() {
        return DateUtils.monthsAway(-1);
    }

    public static Date getLastWeekDayOfPreviousWeek() {
        return DateUtils.getLastWeekDayOfPreviousWeek(DateUtils.now());
    }

    public static Date getLastWeekDayOfPreviousWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        int diff = -(dayOfWeek + 1);
        return DateUtils.addDays(date, diff);
    }

    public static Boolean isLastWeekDayOfWeek() {
        return DateUtils.getDayOfWeek() == DayOfWeek.FRIDAY;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        DateUtils.truncateTime(calendar);
        return calendar.getTime();
    }

    public static Boolean isLastWeekDayOfMonth() {
        return DateUtils.today().equals(DateUtils.getLastWeekDayOfMonth());
    }

    public static Date getLastWeekDayOfMonth() {
        return DateUtils.getLastWeekDayOfMonth(DateUtils.now());
    }

    public static Date getLastWeekDayOfMonth(Date date) {
        Date lastDayOfMonth = DateUtils.getLastDayOfMonth(date);
        DayOfWeek dayOfWeek = DateUtils.getDayOfWeek(lastDayOfMonth);
        if (dayOfWeek.equals((Object)DayOfWeek.SATURDAY)) {
            return DateUtils.addDays(lastDayOfMonth, -1);
        }
        if (dayOfWeek.equals((Object)DayOfWeek.SUNDAY)) {
            return DateUtils.addDays(lastDayOfMonth, -2);
        }
        return lastDayOfMonth;
    }

    public static Date getLastDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 11);
        calendar.set(5, 31);
        DateUtils.truncateTime(calendar);
        return calendar.getTime();
    }

    public static Boolean isLastWeekDayOfYear() {
        return DateUtils.today().equals(DateUtils.getLastWeekDayOfYear());
    }

    public static Date getLastWeekDayOfYear() {
        return DateUtils.getLastWeekDayOfYear(DateUtils.now());
    }

    public static Date getLastWeekDayOfYear(Date date) {
        Date lastDayOfYear = DateUtils.getLastDayOfYear(date);
        DayOfWeek dayOfWeek = DateUtils.getDayOfWeek(lastDayOfYear);
        if (dayOfWeek.equals((Object)DayOfWeek.SATURDAY)) {
            return DateUtils.addDays(lastDayOfYear, -1);
        }
        if (dayOfWeek.equals((Object)DayOfWeek.SUNDAY)) {
            return DateUtils.addDays(lastDayOfYear, -2);
        }
        return lastDayOfYear;
    }

    public static Integer differenceInDays(Date fromDate, Date toDate) {
        Long diff = toDate.getTime() - fromDate.getTime();
        diff = diff / TimeUnit.DAYS.toMillis(1L);
        return diff.intValue();
    }

    public static double differenceInHours(Date fromDate, Date toDate) {
        double diff = toDate.getTime() - fromDate.getTime();
        return diff /= (double)TimeUnit.HOURS.toMillis(1L);
    }

    public static Integer differenceInMinutes(Date fromDate, Date toDate) {
        Long diff = toDate.getTime() - fromDate.getTime();
        diff = diff / TimeUnit.MINUTES.toMillis(1L);
        return diff.intValue();
    }

    public static String formatDuration(long duration) {
        long hours = TimeUnit.MILLISECONDS.toHours(duration);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - hours * 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - hours * 60L * 60L - minutes * 60L;
        long milliseconds = TimeUnit.MILLISECONDS.toMillis(duration) - hours * 60L * 60L * 1000L - minutes * 60L * 1000L - seconds * 1000L;
        StringBuilder builder = new StringBuilder();
        if (hours > 0L) {
            builder.append(hours);
            builder.append("h, ");
        }
        if (minutes > 0L || builder.length() > 0) {
            builder.append(minutes);
            builder.append("m, ");
        }
        if (seconds > 0L || builder.length() > 0) {
            builder.append(seconds);
            builder.append("s, ");
        }
        if (milliseconds >= 0L) {
            builder.append(milliseconds);
            builder.append("ms");
        }
        return builder.toString();
    }
}

