/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.exception;

import com.jdroid.java.collections.Maps;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;

public abstract class AbstractException
extends RuntimeException {
    private static final long serialVersionUID = 6296155655850331666L;
    public static final int CRITICAL_PRIORITY = 10;
    public static final int NORMAL_PRIORITY = 50;
    public static final int LOW_PRIORITY = 90;
    private Map<String, Object> parameters = Maps.newHashMap();
    private String title;
    private String description;
    private Boolean trackable = true;
    private Boolean ignoreStackTrace = false;
    private int priorityLevel = 50;

    public AbstractException() {
    }

    public AbstractException(String message, Throwable cause) {
        super(message, cause);
    }

    public AbstractException(String message) {
        super(message);
    }

    public AbstractException(Throwable cause) {
        super(cause);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Boolean hasParameter(String key) {
        return this.parameters.containsKey(key);
    }

    public <E> E getParameter(String key) {
        return (E)this.parameters.get(key);
    }

    public void addParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean isTrackable() {
        return this.trackable;
    }

    public AbstractException setTrackable(Boolean trackable) {
        this.trackable = trackable;
        return this;
    }

    public Throwable getThrowableToLog() {
        return this;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public void setPriorityLevel(int priorityLevel) {
        this.priorityLevel = priorityLevel;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.ignoreStackTrace != false ? null : super.getStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream err) {
        if (this.ignoreStackTrace.booleanValue()) {
            return;
        }
        super.printStackTrace(err);
    }

    @Override
    public void printStackTrace(PrintWriter err) {
        if (this.ignoreStackTrace.booleanValue()) {
            return;
        }
        super.printStackTrace(err);
    }

    public void setIgnoreStackTrace(Boolean ignoreStackTrace) {
        this.ignoreStackTrace = ignoreStackTrace;
    }

    public Boolean isIgnoreStackTrace() {
        return this.ignoreStackTrace;
    }
}

