/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.repository;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.Maps;
import com.jdroid.java.domain.Identifiable;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.repository.Repository;
import com.jdroid.java.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class CacheWrapperRepository<T extends Identifiable>
implements Repository<T> {
    private static final Logger LOGGER = LoggerUtils.getLogger(CacheWrapperRepository.class);
    private Repository<T> wrappedRepository;
    private Map<String, T> cache;
    private List<String> cachedIds;
    private Boolean synced;

    public CacheWrapperRepository(Repository<T> wrappedRepository) {
        this.wrappedRepository = wrappedRepository;
        this.cache = this.createCacheMap();
        this.cachedIds = Lists.newArrayList();
        this.synced = false;
    }

    protected Map<String, T> createCacheMap() {
        return Maps.newConcurrentHashMap();
    }

    protected Map<String, T> getCache() {
        return this.cache;
    }

    public List<T> getCachedItems() {
        return Lists.newArrayList(this.cache.values());
    }

    protected Repository<T> getWrappedRepository() {
        return this.wrappedRepository;
    }

    protected Boolean isSynced() {
        return this.synced;
    }

    @Override
    public T get(String id) {
        Identifiable item = null;
        if (this.synced.booleanValue() && !this.cachedIds.contains(id)) {
            this.cachedIds.add(id);
        }
        if (this.cachedIds.contains(id)) {
            item = (Identifiable)this.cache.get(id);
            if (item != null) {
                LOGGER.debug("Retrieved cached object: " + item.getClass().getSimpleName() + ". [ " + item + " ]");
            } else {
                LOGGER.debug("Retrieved cached object with id: " + id + ". [ " + item + " ]");
            }
        } else {
            item = (Identifiable)this.wrappedRepository.get(id);
            if (item != null) {
                this.cache.put(id, item);
            }
            this.cachedIds.add(id);
        }
        return (T)item;
    }

    @Override
    public void add(T item) {
        this.wrappedRepository.add(item);
        this.addToCache(item);
    }

    @Override
    public void addAll(Collection<T> items) {
        this.wrappedRepository.addAll(items);
        for (Identifiable each : items) {
            this.addToCache(each);
        }
    }

    @Override
    public void update(T item) {
        this.wrappedRepository.update(item);
        this.addToCache(item);
    }

    @Override
    public void remove(T item) {
        this.wrappedRepository.remove(item);
        this.removeFromCache(item);
    }

    @Override
    public void removeAll() {
        this.wrappedRepository.removeAll();
        this.cache.clear();
        this.cachedIds.clear();
        this.synced = true;
    }

    @Override
    public void removeAll(Collection<T> items) {
        this.wrappedRepository.removeAll(items);
        for (Identifiable each : items) {
            this.addToCache(each);
            this.removeFromCache(each);
        }
    }

    @Override
    public List<T> getByField(String fieldName, Object ... values) {
        LOGGER.info("The getByField query is not cached. Repository [" + this.wrappedRepository.getClass().getSimpleName() + "]. Field name [" + fieldName + "]");
        return this.wrappedRepository.getByField(fieldName, values);
    }

    @Override
    public T getItemByField(String fieldName, Object ... values) {
        LOGGER.info("The getItemByField query is not cached. Repository [" + this.wrappedRepository.getClass().getSimpleName() + "]. Field name [" + fieldName + "]");
        return this.wrappedRepository.getItemByField(fieldName, values);
    }

    @Override
    public List<T> getAll() {
        if (this.synced.booleanValue()) {
            ArrayList<T> items = Lists.newArrayList(this.cache.values());
            LOGGER.info("Retrieved all cached objects [" + items.size() + "]");
            return items;
        }
        List<T> items = this.wrappedRepository.getAll();
        this.cache.clear();
        this.cachedIds.clear();
        for (Identifiable each : items) {
            this.addToCache(each);
        }
        this.synced = true;
        return items;
    }

    @Override
    public List<T> getByIds(List<String> ids) {
        if (this.synced.booleanValue()) {
            ArrayList<T> items = Lists.newArrayList();
            for (String each : ids) {
                items.add(this.cache.get(each));
            }
            LOGGER.info("Retrieved all cached objects [" + items.size() + "] with ids: " + ids);
            return items;
        }
        List<T> items = this.wrappedRepository.getByIds(ids);
        for (Identifiable each : items) {
            this.addToCache(each);
        }
        return items;
    }

    private void addToCache(T each) {
        if (each.getId() == null) {
            throw new UnexpectedException("Missing item id");
        }
        this.cache.put(each.getId(), each);
        this.cachedIds.add(each.getId());
    }

    private void removeFromCache(T each) {
        if (each.getId() == null) {
            throw new UnexpectedException("Missing item id");
        }
        this.cache.remove(each.getId());
        this.cachedIds.remove(each.getId());
    }

    @Override
    public void remove(String id) {
        this.wrappedRepository.remove(id);
        this.cache.remove(id);
        this.cachedIds.remove(id);
    }

    @Override
    public Boolean isEmpty() {
        Boolean isEmpty;
        if (this.synced.booleanValue()) {
            return this.cache.isEmpty();
        }
        this.synced = isEmpty = this.wrappedRepository.isEmpty();
        return isEmpty;
    }

    @Override
    public Long getSize() {
        if (this.synced.booleanValue()) {
            return this.cache.size();
        }
        Long size = this.wrappedRepository.getSize();
        this.synced = size == 0L;
        return size;
    }

    @Override
    public void replaceAll(Collection<T> items) {
        this.wrappedRepository.replaceAll(items);
        for (Identifiable each : items) {
            this.addToCache(each);
        }
    }

    @Override
    public T getUniqueInstance() {
        if (!this.cache.isEmpty() || this.synced.booleanValue()) {
            return (T)(this.cache.isEmpty() ? null : (Identifiable)this.cache.values().iterator().next());
        }
        T item = this.wrappedRepository.getUniqueInstance();
        if (item != null) {
            this.addToCache(item);
        }
        return item;
    }

    public void clearCache() {
        this.cache.clear();
        this.cachedIds.clear();
        this.synced = false;
    }
}

