/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.repository;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.Maps;
import com.jdroid.java.domain.Identifiable;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.repository.Repository;
import com.jdroid.java.utils.LoggerUtils;
import com.jdroid.java.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class InMemoryRepository<T extends Identifiable>
implements Repository<T> {
    private static final Logger LOGGER = LoggerUtils.getLogger(InMemoryRepository.class);
    private long nextId = 1L;
    private Map<String, T> items = Maps.newLinkedHashMap();

    @Override
    public void add(T item) {
        if (item.getId() == null) {
            ReflectionUtils.setId(item, this.nextId++);
        }
        this.items.put(item.getId(), item);
        LOGGER.debug("Added object in memory: " + item);
    }

    @Override
    public void addAll(Collection<T> items) {
        for (Identifiable item : items) {
            this.add(item);
        }
        LOGGER.debug("Stored objects in memory:\n" + items);
    }

    @Override
    public void update(T item) {
        if (item.getId() == null) {
            throw new UnexpectedException("Item with null id can not be updated");
        }
        this.items.put(item.getId(), item);
        LOGGER.debug("Updated object in memory: " + item);
    }

    @Override
    public void remove(T item) {
        this.items.remove(item.getId());
        LOGGER.debug("Deleted object from memory: " + item);
    }

    @Override
    public void removeAll(Collection<T> items) {
        for (Identifiable item : items) {
            this.remove(item);
        }
        LOGGER.debug("Deleted objects in memory: " + items);
    }

    @Override
    public void replaceAll(Collection<T> items) {
        this.removeAll();
        this.addAll(items);
    }

    @Override
    public List<T> getAll() {
        ArrayList<T> results = Lists.newArrayList(this.items.values());
        LOGGER.debug("Retrieved all objects [" + results.size() + "] from memory");
        return results;
    }

    @Override
    public T get(String id) {
        return (T)((Identifiable)this.items.get(id));
    }

    @Override
    public void removeAll() {
        this.items.clear();
        LOGGER.debug("Deleted from memory all objects from this repository");
    }

    @Override
    public void remove(String id) {
        this.items.remove(id);
    }

    @Override
    public Boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public Long getSize() {
        return this.items.size();
    }

    @Override
    public List<T> getByField(String fieldName, Object ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T getItemByField(String fieldName, Object ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> getByIds(List<String> ids) {
        ArrayList<Identifiable> itemsList = Lists.newArrayList();
        for (String each : ids) {
            Identifiable item = (Identifiable)this.items.get(each);
            if (item == null) continue;
            itemsList.add(item);
        }
        return itemsList;
    }

    @Override
    public T getUniqueInstance() {
        return (T)(this.items.isEmpty() ? null : (Identifiable)this.items.values().iterator().next());
    }
}

