/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.scheduler;

import com.jdroid.java.date.DateUtils;
import com.jdroid.java.utils.LoggerUtils;
import java.util.Date;

public abstract class AbstractScheduler {
    private Boolean inProgress = false;
    private Date executionStartDate;
    private Date executionEndDate;

    protected void execute() {
        if (this.isEnabled().booleanValue()) {
            if (this.acquireLock().booleanValue()) {
                try {
                    this.doExecute();
                }
                catch (Exception e) {
                    this.onException(e);
                }
                finally {
                    this.releaseLock();
                }
            } else {
                LoggerUtils.getLogger(this.getClass()).info(this.getClass().getSimpleName() + " already in progress, skipping this schedule.");
            }
        }
    }

    protected abstract void doExecute();

    protected void onException(Exception e) {
        LoggerUtils.getLogger(this.getClass()).error("Unexpected error when executing " + this.getClass().getSimpleName(), (Throwable)e);
    }

    protected Boolean isEnabled() {
        return true;
    }

    private synchronized Boolean acquireLock() {
        if (!this.inProgress.booleanValue()) {
            this.inProgress = true;
            this.executionStartDate = DateUtils.now();
            return true;
        }
        return false;
    }

    private synchronized void releaseLock() {
        this.inProgress = false;
        this.executionEndDate = new Date();
    }

    public Date getLastExecutionStartDate() {
        return this.executionStartDate;
    }

    public Date getLastExecutionEndDate() {
        return this.executionEndDate;
    }
}

