/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.search;

import com.jdroid.java.collections.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PagedResult<T> {
    private Boolean lastPage;
    private List<T> results;

    public PagedResult(List<T> results, Boolean lastPage) {
        this.results = results;
        this.lastPage = lastPage;
    }

    public PagedResult(Boolean lastPage) {
        this(Lists.newArrayList(), lastPage);
    }

    public PagedResult(List<T> results) {
        this(results, true);
    }

    public PagedResult() {
        this(true);
    }

    public void addResult(T result) {
        this.results.add(result);
    }

    public void addResults(Collection<T> results) {
        this.results.addAll(results);
    }

    public List<T> getResults() {
        return this.results;
    }

    public void sortResults(Comparator<T> comparator) {
        Collections.sort(this.results, comparator);
    }

    public boolean isLastPage() {
        return this.lastPage;
    }
}

