/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.exception.UnexpectedException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class EncodingUtils {
    public static final String UTF8 = "UTF-8";
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final int NOT_FOUND = -1;

    public static String encodeURL(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder encoded = null;
        int oldLength = s.length();
        int current = 0;
        while (current < oldLength) {
            int nextAllowed;
            int nextToEncode;
            for (nextToEncode = current; nextToEncode < oldLength && EncodingUtils.isAllowed(s.charAt(nextToEncode), null); ++nextToEncode) {
            }
            if (nextToEncode == oldLength) {
                if (current == 0) {
                    return s;
                }
                encoded.append(s, current, oldLength);
                return encoded.toString();
            }
            if (encoded == null) {
                encoded = new StringBuilder();
            }
            if (nextToEncode > current) {
                encoded.append(s, current, nextToEncode);
            }
            current = nextToEncode;
            for (nextAllowed = current + 1; nextAllowed < oldLength && !EncodingUtils.isAllowed(s.charAt(nextAllowed), null); ++nextAllowed) {
            }
            String toEncode = s.substring(current, nextAllowed);
            try {
                byte[] bytes;
                for (byte aByte : bytes = toEncode.getBytes(UTF8)) {
                    encoded.append('%');
                    encoded.append(HEX_DIGITS[(aByte & 0xF0) >> 4]);
                    encoded.append(HEX_DIGITS[aByte & 0xF]);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new UnexpectedException(e);
            }
            current = nextAllowed;
        }
        return encoded == null ? s : encoded.toString();
    }

    private static boolean isAllowed(char c, String allow) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "_-!.~'()*/".indexOf(c) != -1 || allow != null && allow.indexOf(c) != -1;
    }

    public static String decodeURL(String url) {
        String decodedString = null;
        try {
            decodedString = URLDecoder.decode(url, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException(e);
        }
        return decodedString;
    }
}

