/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.utils.LoggerUtils;
import com.jdroid.java.utils.StreamUtils;
import com.jdroid.java.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;

public abstract class FileUtils {
    private static final Logger LOGGER = LoggerUtils.getLogger(FileUtils.class);
    public static final int BYTES_TO_MB = 0x100000;

    public static byte[] readAsBytes(File file) throws IOException {
        return StreamUtils.readAsBytes(new FileInputStream(file));
    }

    public static List<String> readLines(File file) {
        try {
            return StreamUtils.readLines(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new UnexpectedException("Error reading the file", (Throwable)e);
        }
    }

    public static File checkFile(String filePath) {
        File file = new File(filePath);
        if (!FileUtils.exist(filePath)) {
            file.mkdirs();
        }
        return file;
    }

    public static boolean exist(String filePath) {
        return new File(filePath).exists();
    }

    public static void forceDelete(File file) {
        if (file.exists()) {
            File[] listFiles;
            if (file.isDirectory() && (listFiles = file.listFiles()) != null) {
                for (File contentFile : listFiles) {
                    FileUtils.forceDelete(contentFile);
                }
            }
            if (file.delete()) {
                LOGGER.debug("File " + file.getPath() + " was successfully deleted.");
            } else {
                LOGGER.warn("File " + file.getPath() + " couldn't be deleted.");
            }
        }
    }

    public static boolean renameOrMove(File fileToBeMoved, File destination) {
        boolean result = fileToBeMoved.renameTo(destination);
        if (result) {
            LOGGER.debug("File " + fileToBeMoved.getPath() + " was succesfully renamed or moved.");
        } else {
            LOGGER.error("File " + fileToBeMoved.getPath() + " couldn't be renamed or moved.");
        }
        return result;
    }

    public static File createTempFile() {
        File file;
        try {
            file = File.createTempFile("tempFile", ".tmp");
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        return file;
    }

    public static File createTempDir() {
        File file = FileUtils.createTempFile();
        File dir = new File(file.getAbsolutePath() + "dir");
        dir.mkdir();
        return dir;
    }

    public static File toTempFile(String content) {
        File file;
        try {
            file = File.createTempFile("tempFile", ".tmp");
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        try {
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.append(content);
            printWriter.close();
            return file;
        }
        catch (FileNotFoundException e) {
            throw new UnexpectedException(e);
        }
    }

    public static void createFile(String content, String parentPath, String fileName) {
        try {
            new File(parentPath).mkdirs();
            PrintWriter printWriter = new PrintWriter(parentPath + File.separatorChar + fileName);
            printWriter.append(StringUtils.defaultString(content));
            printWriter.close();
        }
        catch (FileNotFoundException e) {
            throw new UnexpectedException(e);
        }
    }

    public static String toString(File file) {
        try {
            return StreamUtils.toString(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new UnexpectedException("The file doesn't exist [" + file + "]", (Throwable)e);
        }
    }

    public static void writeLines(File file, List<String> lines) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            for (String line : lines) {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
            StreamUtils.safeClose(bufferedWriter);
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
    }

    public static void copyStream(InputStream source, File target) {
        FileOutputStream out = null;
        try {
            File dir = target.getParentFile();
            if (dir != null) {
                dir.mkdirs();
            }
            out = new FileOutputStream(target);
            StreamUtils.copyStream(source, out);
        }
        catch (IOException e) {
            try {
                throw new UnexpectedException("Error copying the file to [" + target + "]", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(out);
                throw throwable;
            }
        }
        StreamUtils.safeClose(out);
    }

    public static File zipFile(String directoryToZipPath) {
        File file;
        ZipOutputStream zipOutputStream = null;
        try {
            File zipFile = FileUtils.createTempFile();
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            File directoryToZip = new File(directoryToZipPath);
            FileUtils.zipFileItem(directoryToZipPath, zipOutputStream, directoryToZip, null);
            file = zipFile;
        }
        catch (FileNotFoundException e) {
            try {
                throw new UnexpectedException(e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(zipOutputStream);
                throw throwable;
            }
        }
        StreamUtils.safeClose(zipOutputStream);
        return file;
    }

    private static void zipFileItem(String directoryToZipPath, ZipOutputStream zipOutputStream, File fileItem, String parentItemPath) {
        try {
            String[] files;
            for (String file : files = fileItem.list()) {
                String itemRelativePath = (parentItemPath != null ? parentItemPath + File.separatorChar : "") + file;
                File itemFile = new File(directoryToZipPath + File.separatorChar + itemRelativePath);
                if (itemFile.isDirectory()) {
                    FileUtils.zipFileItem(directoryToZipPath, zipOutputStream, itemFile, itemRelativePath);
                    continue;
                }
                FileInputStream entryInputStream = new FileInputStream(fileItem.getAbsolutePath() + File.separatorChar + file);
                ZipEntry entry = new ZipEntry(itemRelativePath);
                zipOutputStream.putNextEntry(entry);
                StreamUtils.copyStream(entryInputStream, zipOutputStream, false);
                entryInputStream.close();
            }
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
    }

    public static long getDirectorySize(File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        long size = 0L;
        File[] files = directory.listFiles();
        if (files == null) {
            return 0L;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                size += FileUtils.getDirectorySize(file);
                continue;
            }
            size += file.length();
        }
        return size;
    }

    public static long getFileSize(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
        return file.length();
    }

    public static float getDirectorySizeInMB(File directory) {
        return (float)FileUtils.getDirectorySize(directory) / 1048576.0f;
    }

    public static float getFileSizeInMB(File file) {
        return (float)FileUtils.getFileSize(file) / 1048576.0f;
    }
}

