/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.domain.Identifiable;
import com.jdroid.java.exception.UnexpectedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class ReflectionUtils {
    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedException(e);
        }
    }

    public static Class<?> getSafeClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> T safeNewInstance(String className) {
        try {
            return ReflectionUtils.newInstance(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T newInstance(String className) {
        return (T)ReflectionUtils.newInstance(ReflectionUtils.getClass(className));
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new UnexpectedException("Unable to instantiate class [" + clazz.getSimpleName() + "]", (Throwable)e);
        }
    }

    public static <T> T newInstance(String className, List<Class<?>> parameterTypes, List<Object> parameterValues) {
        return (T)ReflectionUtils.newInstance(ReflectionUtils.getClass(className), parameterTypes, parameterValues);
    }

    public static <T> T newInstance(Class<T> clazz, List<Class<?>> parameterTypes, List<Object> parameterValues) {
        try {
            Constructor<T> constructor = clazz.getConstructor(parameterTypes.toArray(new Class[0]));
            return constructor.newInstance(parameterValues.toArray(new Object[0]));
        }
        catch (Exception e) {
            throw new UnexpectedException("Unable to instantiate class [" + clazz.getSimpleName() + "]", (Throwable)e);
        }
    }

    public static void set(Object object, String fieldName, Object value) {
        Field field = ReflectionUtils.getField(object.getClass(), fieldName);
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new UnexpectedException(e);
        }
        finally {
            field.setAccessible(false);
        }
    }

    public static void setStaticField(Class<?> clazz, String fieldName, Object value) {
        Field field = ReflectionUtils.getField(clazz, fieldName);
        field.setAccessible(true);
        try {
            field.set(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new UnexpectedException(e);
        }
        finally {
            field.setAccessible(false);
        }
    }

    public static Object get(Field field, Object object) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new UnexpectedException(e);
        }
    }

    public static Object get(Object object, String fieldName) {
        Field field = ReflectionUtils.getField(object, fieldName);
        field.setAccessible(true);
        return ReflectionUtils.get(field, object);
    }

    public static Object invokeStaticMethod(String className, String methodName, List<Class<?>> parameterTypes, List<Object> parameterValues) {
        return ReflectionUtils.invokeStaticMethod(ReflectionUtils.getClass(className), methodName, parameterTypes, parameterValues);
    }

    public static Object invokeStaticMethod(Class<?> clazz, String methodName, List<Class<?>> parameterTypes, List<Object> parameterValues) {
        return ReflectionUtils.invokeMethod(clazz, null, methodName, parameterTypes, parameterValues);
    }

    public static Object invokeMethod(String className, Object obj, String methodName, List<Class<?>> parameterTypes, List<Object> parameterValues) {
        return ReflectionUtils.invokeMethod(ReflectionUtils.getClass(className), obj, methodName, parameterTypes, parameterValues);
    }

    public static Object invokeMethod(Class<?> clazz, Object obj, String methodName, List<Class<?>> parameterTypes, List<Object> parameterValues) {
        try {
            Method method = clazz.getMethod(methodName, parameterTypes.toArray(new Class[0]));
            return method.invoke(obj, parameterValues.toArray(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new UnexpectedException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnexpectedException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException(e);
        }
    }

    public static Object getStaticFieldValue(Class<?> clazz, String fieldName) {
        Field field = ReflectionUtils.getField(clazz, fieldName);
        return ReflectionUtils.get(field, null);
    }

    public static Object getStaticFieldValue(Class<?> clazz, String fieldName, Object defaultValue) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new UnexpectedException(e);
        }
        catch (NoSuchFieldException e) {
            return defaultValue;
        }
    }

    public static Field getField(Object object, String fieldName) {
        try {
            return object.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new UnexpectedException(e);
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectionUtils.getField(clazz.getSuperclass(), fieldName);
            }
            throw new UnexpectedException("The class '" + clazz.getName() + "' doesn't have a field named '" + fieldName + "'.");
        }
    }

    public static <T> T getFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtils.getField(object.getClass(), fieldName);
        field.setAccessible(true);
        try {
            return (T)field.get(object);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Class<?> getType(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            return field.getType();
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new UnexpectedException(e);
        }
    }

    public static void setId(Identifiable identifiable, Object id) {
        ReflectionUtils.set(identifiable, "id", id);
    }
}

