/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.utils.LoggerUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class StreamUtils {
    private static final Logger LOGGER = LoggerUtils.getLogger(StreamUtils.class);
    private static final int BUFFER_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAsBytes(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[16384];
        BufferedInputStream is = new BufferedInputStream(inputStream);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int cnt = ((InputStream)is).read(buffer);
            while (cnt != -1) {
                outputStream.write(buffer, 0, cnt);
                cnt = ((InputStream)is).read(buffer);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            StreamUtils.safeClose(is);
        }
    }

    public static List<String> readLines(InputStream inputStream) {
        ArrayList<String> arrayList;
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> lines = Lists.newArrayList();
            reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (IOException e) {
            try {
                throw new UnexpectedException("Error reading the stream", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(reader);
                throw throwable;
            }
        }
        StreamUtils.safeClose(reader);
        return arrayList;
    }

    public static String toString(InputStream in) {
        return StreamUtils.toString(in, true);
    }

    public static String toString(InputStream in, Boolean closeStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder contentBuilder = new StringBuilder();
        String text = null;
        try {
            Boolean firstLine = true;
            while ((text = reader.readLine()) != null) {
                if (!firstLine.booleanValue()) {
                    contentBuilder.append(System.getProperty("line.separator"));
                }
                firstLine = false;
                contentBuilder.append(text);
            }
        }
        catch (IOException e) {
            throw new UnexpectedException("Error reading the stream", (Throwable)e);
        }
        finally {
            if (closeStream.booleanValue()) {
                StreamUtils.safeClose(in);
            }
        }
        return contentBuilder.toString();
    }

    public static void copyStream(InputStream source, OutputStream destin, Boolean closeOutputStream) {
        try {
            int count = 0;
            byte[] buffer = new byte[16384];
            while ((count = source.read(buffer, 0, 16384)) != -1) {
                destin.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new UnexpectedException("Error copying file", (Throwable)e);
        }
        finally {
            if (closeOutputStream.booleanValue()) {
                StreamUtils.safeClose(destin);
            }
        }
    }

    public static void copyStream(InputStream source, OutputStream destin) {
        StreamUtils.copyStream(source, destin, true);
    }

    public static ByteArrayInputStream copy(InputStream source) {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        StreamUtils.copyStream(source, tmp, true);
        return new ByteArrayInputStream(tmp.toByteArray());
    }

    /*
     * Exception decompiling
     */
    public static boolean isEquals(InputStream input1, InputStream input2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOGGER.warn("Exception thrown when trying to close the closeable", (Throwable)e);
            }
        }
    }
}

