/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtils {
    public static final String EMPTY = "";
    public static final String ELLIPSIS = "...";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    public static final String DASH = "-";
    public static final String SLASH = "/";
    public static final String DOT = ".";
    public static final String NEW_LINE = "\n";
    public static final String UNDERSCORE = "_";
    public static final String BANG = "!";
    public static final String PIPE = "|";
    private static final String PLACEHOLDER_PATTERN = "\\$\\{(.*?)\\}";
    private static final String ALPHANUMERIC_PATTERN = "([^\\w\\s])*";

    public static String getNotEmptyString(String text) {
        return StringUtils.isEmpty(text) != false ? null : text;
    }

    public static Boolean equal(String text1, String text2) {
        return StringUtils.defaultString(text1).equals(StringUtils.defaultString(text2));
    }

    public static Boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static Boolean isNotEmpty(String text) {
        return StringUtils.isEmpty(text) == false;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String defaultString(String str) {
        return StringUtils.defaultString(str, EMPTY);
    }

    public static String defaultString(String str, String defaultString) {
        return str == null ? defaultString : str;
    }

    public static String capitalize(String text) {
        if (StringUtils.isEmpty(text).booleanValue() || text.length() == 1) {
            return text.toUpperCase();
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
    }

    public static String capitalizeWords(String str) {
        return StringUtils.capitalizeWords(str, null);
    }

    public static String capitalizeWords(String str, char[] delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (str == null || str.length() == 0 || delimLen == 0) {
            return str;
        }
        int strLen = str.length();
        StringBuilder builder = new StringBuilder(strLen);
        boolean capitalizeNext = true;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (StringUtils.isDelimiter(ch, delimiters)) {
                builder.append(ch);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                builder.append(Character.toTitleCase(ch));
                capitalizeNext = false;
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        for (char delimiter : delimiters) {
            if (ch != delimiter) continue;
            return true;
        }
        return false;
    }

    public static String join(Collection<?> objectsToJoin, String separator) {
        if (objectsToJoin != null && !objectsToJoin.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Object object : objectsToJoin) {
                builder.append(object != null ? object.toString() : EMPTY);
                builder.append(separator);
            }
            return builder.substring(0, builder.length() - separator.length());
        }
        return EMPTY;
    }

    public static String join(Collection<?> objectsToJoin) {
        return StringUtils.join(objectsToJoin, COMMA);
    }

    public static String truncate(String text, Integer maxCharacters, Boolean truncateWords) {
        if (StringUtils.isNotBlank(text)) {
            StringBuilder truncatedTextBuilder = new StringBuilder();
            if (text.length() > maxCharacters) {
                if (truncateWords.booleanValue()) {
                    if (maxCharacters <= ELLIPSIS.length()) {
                        truncatedTextBuilder.append(text.substring(0, maxCharacters));
                    } else {
                        truncatedTextBuilder.append(text.substring(0, maxCharacters - ELLIPSIS.length()));
                        truncatedTextBuilder.append(ELLIPSIS);
                    }
                } else {
                    ArrayList<String> words = Lists.newArrayList(text.split(SPACE));
                    Iterator it = words.iterator();
                    int usedChars = 0;
                    Boolean exit = false;
                    while (it.hasNext() && !exit.booleanValue()) {
                        int increment;
                        String word = (String)it.next();
                        int n = increment = usedChars == 0 ? word.length() : word.length() + 1;
                        if (usedChars + increment <= maxCharacters) {
                            truncatedTextBuilder.append(usedChars == 0 ? word : SPACE + word);
                            usedChars += increment;
                            continue;
                        }
                        exit = true;
                    }
                }
            } else {
                truncatedTextBuilder.append(text);
            }
            return truncatedTextBuilder.toString();
        }
        return text;
    }

    public static String truncate(String text, Integer maxCharacters) {
        return StringUtils.truncate(text, maxCharacters, true);
    }

    public static Set<String> extractPlaceHolders(String string) {
        Matcher matcher = Pattern.compile(PLACEHOLDER_PATTERN).matcher(string);
        HashSet<String> placeHolders = Sets.newHashSet();
        while (matcher.find()) {
            placeHolders.add(matcher.group(1));
        }
        return placeHolders;
    }

    public static String toAlphanumeric(String value) {
        return Pattern.compile(ALPHANUMERIC_PATTERN).matcher(value).replaceAll(EMPTY);
    }

    public static List<String> splitWithCommaSeparator(String text) {
        return StringUtils.split(text, COMMA);
    }

    public static List<String> split(String text, String separator) {
        ArrayList<String> values = StringUtils.isNotEmpty(text) != false ? Lists.newArrayList(text.split(separator)) : Lists.newArrayList();
        return values;
    }

    public static String getFirstToken(String string, String token) {
        if (string != null && string.contains(token)) {
            return string.split(token)[0];
        }
        return string;
    }

    public static String getFirstToken(String string) {
        return StringUtils.getFirstToken(string, COMMA);
    }

    public static String wordWrapToTwoLines(String text, int minLength) {
        String wordWrapText;
        String string = wordWrapText = text != null ? text.trim() : null;
        if (wordWrapText != null && wordWrapText.length() > minLength) {
            int rightSpaceIndex;
            int middle = wordWrapText.length() / 2;
            int leftSpaceIndex = wordWrapText.substring(0, middle).lastIndexOf(SPACE);
            int wordWrapIndex = rightSpaceIndex = wordWrapText.indexOf(SPACE, middle);
            if (leftSpaceIndex >= 0 && (rightSpaceIndex < 0 || middle - leftSpaceIndex < rightSpaceIndex - middle)) {
                wordWrapIndex = leftSpaceIndex;
            }
            if (wordWrapIndex >= 0) {
                wordWrapText = wordWrapText.substring(0, wordWrapIndex) + NEW_LINE + wordWrapText.substring(wordWrapIndex + 1);
            }
        }
        return wordWrapText;
    }

    public static String replaceValues(String template, Map<String, String> values) {
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile(PLACEHOLDER_PATTERN, 32);
        Matcher matcher = pattern.matcher(template);
        while (matcher.find()) {
            String key = matcher.group(1);
            String replacement = values.get(key);
            if (replacement == null) {
                throw new IllegalArgumentException("Template contains unmapped key: " + key);
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static boolean hasOnlyCharacters(String name) {
        return StringUtils.isEmpty(name) == false && name.matches("[A-Za-z\\s]*");
    }

    public static CharSequence removeTrailingWhitespaces(CharSequence charSequence) {
        CharSequence result = charSequence;
        if (charSequence != null && charSequence.length() > 0) {
            int lastIndex;
            int index;
            for (index = lastIndex = charSequence.length() - 1; index >= 0 && StringUtils.isAnySpaceChar(charSequence.charAt(index)); --index) {
            }
            if (index < lastIndex) {
                result = charSequence.subSequence(0, index + 1);
            }
        }
        return result;
    }

    private static boolean isAnySpaceChar(char character) {
        return Character.isSpaceChar(character) || Character.isWhitespace(character);
    }
}

