/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.utils.StringUtils;

public class TypeUtils {
    public static Float getFloat(Object value) {
        return TypeUtils.getFloat(value, null);
    }

    public static Float getFloat(String value) {
        return TypeUtils.getFloat(value, null);
    }

    public static Float getFloat(String value, Float defaultValue) {
        return StringUtils.isNotEmpty(value) != false ? Float.valueOf(value) : defaultValue;
    }

    public static Float getFloat(Object value, Float defaultValue) {
        if (value != null) {
            if (value instanceof Float) {
                return (Float)value;
            }
            return TypeUtils.getFloat(value.toString(), defaultValue);
        }
        return defaultValue;
    }

    public static Float getSafeFloat(String value) {
        return TypeUtils.getSafeFloat(value, null);
    }

    public static Float getSafeFloat(Object value) {
        return TypeUtils.getSafeFloat(value, null);
    }

    public static Float getSafeFloat(Object value, Float defaultValue) {
        try {
            return TypeUtils.getFloat(value, defaultValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Float getSafeFloat(String value, Float defaultValue) {
        return TypeUtils.getSafeFloat((Object)value, defaultValue);
    }

    public static Integer getInteger(Object value) {
        return TypeUtils.getInteger(value, null);
    }

    public static Integer getInteger(String value) {
        return TypeUtils.getInteger(value, null);
    }

    public static Integer getInteger(String value, Integer defaultValue) {
        return StringUtils.isNotEmpty(value) != false ? Integer.valueOf(value) : defaultValue;
    }

    public static Integer getInteger(Object value, Integer defaultValue) {
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return TypeUtils.getInteger(value.toString(), defaultValue);
        }
        return defaultValue;
    }

    public static Integer getSafeInteger(String value) {
        return TypeUtils.getSafeInteger(value, null);
    }

    public static Integer getSafeInteger(Object value) {
        return TypeUtils.getSafeInteger(value, null);
    }

    public static Integer getSafeInteger(Object value, Integer defaultValue) {
        try {
            return TypeUtils.getInteger(value, defaultValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer getSafeInteger(String value, Integer defaultValue) {
        return TypeUtils.getSafeInteger((Object)value, defaultValue);
    }

    public static Long getLong(Object value) {
        return TypeUtils.getLong(value, null);
    }

    public static Long getLong(String value) {
        return TypeUtils.getLong(value, null);
    }

    public static Long getLong(String value, Long defaultValue) {
        return StringUtils.isNotEmpty(value) != false ? Long.valueOf(value) : defaultValue;
    }

    public static Long getLong(Object value, Long defaultValue) {
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            return TypeUtils.getLong(value.toString(), defaultValue);
        }
        return defaultValue;
    }

    public static Long getSafeLong(String value) {
        return TypeUtils.getSafeLong(value, null);
    }

    public static Long getSafeLong(Object value) {
        return TypeUtils.getSafeLong(value, null);
    }

    public static Long getSafeLong(Object value, Long defaultValue) {
        try {
            return TypeUtils.getLong(value, defaultValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long getSafeLong(String value, Long defaultValue) {
        return TypeUtils.getSafeLong((Object)value, defaultValue);
    }

    public static Double getDouble(Object value) {
        return TypeUtils.getDouble(value, null);
    }

    public static Double getDouble(String value) {
        return TypeUtils.getDouble(value, null);
    }

    public static Double getDouble(String value, Double defaultValue) {
        return StringUtils.isNotEmpty(value) != false ? Double.valueOf(value) : defaultValue;
    }

    public static Double getDouble(Object value, Double defaultValue) {
        if (value != null) {
            if (value instanceof Double) {
                return (Double)value;
            }
            return TypeUtils.getDouble(value.toString(), defaultValue);
        }
        return defaultValue;
    }

    public static Double getSafeDouble(String value) {
        return TypeUtils.getSafeDouble(value, null);
    }

    public static Double getSafeDouble(Object value) {
        return TypeUtils.getSafeDouble(value, null);
    }

    public static Double getSafeDouble(Object value, Double defaultValue) {
        try {
            return TypeUtils.getDouble(value, defaultValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Double getSafeDouble(String value, Double defaultValue) {
        return TypeUtils.getSafeDouble((Object)value, defaultValue);
    }

    public static Boolean getBooleanFromNumber(String value) {
        return StringUtils.isNotEmpty(value) != false ? Boolean.valueOf("1".equals(value)) : null;
    }

    public static Boolean getBoolean(Object value) {
        return TypeUtils.getBoolean(value, null);
    }

    public static Boolean getBoolean(String value) {
        return TypeUtils.getBoolean(value, null);
    }

    public static Boolean getBoolean(String value, Boolean defaultValue) {
        if (StringUtils.isNotEmpty(value).booleanValue()) {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            throw new UnexpectedException("Invalid Boolean value: " + value);
        }
        return defaultValue;
    }

    public static Boolean getBoolean(Object value, Boolean defaultValue) {
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return TypeUtils.getBoolean(value.toString(), defaultValue);
        }
        return defaultValue;
    }

    public static Boolean getSafeBoolean(String value) {
        return TypeUtils.getSafeBoolean(value, null);
    }

    public static Boolean getSafeBoolean(Object value) {
        return TypeUtils.getSafeBoolean(value, null);
    }

    public static Boolean getSafeBoolean(Object value, Boolean defaultValue) {
        try {
            return TypeUtils.getBoolean(value, defaultValue);
        }
        catch (UnexpectedException e) {
            return null;
        }
    }

    public static Boolean getSafeBoolean(String value, Boolean defaultValue) {
        return TypeUtils.getSafeBoolean((Object)value, defaultValue);
    }

    public static String getString(Object value) {
        return value != null ? value.toString() : null;
    }
}

