/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.aop;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.Action;
import com.jfinal.core.Controller;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodProxy;

public class Invocation {
    private Action action;
    boolean useInjectTarget;
    private Object target;
    private Method method;
    private Object[] args;
    private MethodProxy methodProxy;
    private Interceptor[] inters;
    private Object returnValue;
    private int index = 0;

    protected Invocation() {
        this.action = null;
    }

    public Invocation(Action action, Controller controller) {
        this.action = action;
        this.inters = action.getInterceptors();
        this.target = controller;
        this.args = action.getParameterGetter().get(controller);
    }

    public Invocation(Object target, Method method, Object[] args, MethodProxy methodProxy, Interceptor[] inters) {
        this.action = null;
        this.target = target;
        this.method = method;
        this.args = args;
        this.methodProxy = methodProxy;
        this.inters = inters;
    }

    public void invoke() {
        if (this.index < this.inters.length) {
            this.inters[this.index++].intercept(this);
        } else if (this.index++ == this.inters.length) {
            try {
                this.returnValue = this.action != null ? this.action.getMethod().invoke(this.target, this.args) : (this.useInjectTarget ? this.methodProxy.invoke(this.target, this.args) : this.methodProxy.invokeSuper(this.target, this.args));
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public Object getArg(int index) {
        if (index >= this.args.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.args[index];
    }

    public void setArg(int index, Object value) {
        if (index >= this.args.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.args[index] = value;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public <T> T getTarget() {
        return (T)this.target;
    }

    public Method getMethod() {
        if (this.action != null) {
            return this.action.getMethod();
        }
        return this.method;
    }

    public String getMethodName() {
        if (this.action != null) {
            return this.action.getMethodName();
        }
        return this.method.getName();
    }

    public <T> T getReturnValue() {
        return (T)this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    public Controller getController() {
        if (this.action == null) {
            throw new RuntimeException("This method can only be used for action interception");
        }
        return (Controller)this.target;
    }

    public String getActionKey() {
        if (this.action == null) {
            throw new RuntimeException("This method can only be used for action interception");
        }
        return this.action.getActionKey();
    }

    public String getControllerKey() {
        if (this.action == null) {
            throw new RuntimeException("This method can only be used for action interception");
        }
        return this.action.getControllerKey();
    }

    public String getViewPath() {
        if (this.action == null) {
            throw new RuntimeException("This method can only be used for action interception");
        }
        return this.action.getViewPath();
    }

    public boolean isActionInvocation() {
        return this.action != null;
    }
}

