/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorManager;
import com.jfinal.config.Routes;
import com.jfinal.core.Action;
import com.jfinal.core.ActionKey;
import com.jfinal.core.Controller;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActionMapping {
    protected static final String SLASH = "/";
    protected Routes routes;
    protected Map<String, Action> mapping = new HashMap<String, Action>();

    public ActionMapping(Routes routes) {
        this.routes = routes;
    }

    protected Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>();
        for (Method m : methods = Controller.class.getMethods()) {
            excludedMethodName.add(m.getName());
        }
        return excludedMethodName;
    }

    protected List<Routes> getRoutesList() {
        List<Routes> routesList = Routes.getRoutesList();
        ArrayList<Routes> ret = new ArrayList<Routes>(routesList.size() + 1);
        ret.add(this.routes);
        ret.addAll(routesList);
        return ret;
    }

    protected void buildActionMapping() {
        this.mapping.clear();
        Set<String> excludedMethodName = this.buildExcludedMethodName();
        InterceptorManager interMan = InterceptorManager.me();
        for (Routes routes : this.getRoutesList()) {
            for (Routes.Route route : routes.getRouteItemList()) {
                Method[] methods;
                Class<? extends Controller> controllerClass = route.getControllerClass();
                Interceptor[] controllerInters = interMan.createControllerInterceptor(controllerClass);
                boolean sonOfController = controllerClass.getSuperclass() == Controller.class;
                for (Method method : methods = sonOfController ? controllerClass.getDeclaredMethods() : controllerClass.getMethods()) {
                    Action action;
                    String actionKey;
                    String methodName = method.getName();
                    if (excludedMethodName.contains(methodName) || sonOfController && !Modifier.isPublic(method.getModifiers())) continue;
                    Interceptor[] actionInters = interMan.buildControllerActionInterceptor(routes.getInterceptors(), controllerInters, controllerClass, method);
                    String controllerKey = route.getControllerKey();
                    ActionKey ak = method.getAnnotation(ActionKey.class);
                    if (ak != null) {
                        actionKey = ak.value().trim();
                        if ("".equals(actionKey)) {
                            throw new IllegalArgumentException(controllerClass.getName() + "." + methodName + "(): The argument of ActionKey can not be blank.");
                        }
                        if (!actionKey.startsWith(SLASH)) {
                            actionKey = SLASH + actionKey;
                        }
                    } else if (methodName.equals("index")) {
                        actionKey = controllerKey;
                    } else {
                        String string = actionKey = controllerKey.equals(SLASH) ? SLASH + methodName : controllerKey + SLASH + methodName;
                    }
                    if (this.mapping.put(actionKey, action = new Action(controllerKey, actionKey, controllerClass, method, methodName, actionInters, route.getFinalViewPath(routes.getBaseViewPath()))) == null) continue;
                    throw new RuntimeException(this.buildMsg(actionKey, controllerClass, method));
                }
            }
        }
        this.routes.clear();
        Action action = this.mapping.get(SLASH);
        if (action != null) {
            this.mapping.put("", action);
        }
    }

    protected String buildMsg(String actionKey, Class<? extends Controller> controllerClass, Method method) {
        StringBuilder sb = new StringBuilder("The action \"").append(controllerClass.getName()).append(".").append(method.getName()).append("()\" can not be mapped, ").append("actionKey \"").append(actionKey).append("\" is already in use.");
        String msg = sb.toString();
        System.err.println("\nException: " + msg);
        return msg;
    }

    public Action getAction(String url, String[] urlPara) {
        Action action = this.mapping.get(url);
        if (action != null) {
            return action;
        }
        int i = url.lastIndexOf(47);
        if (i != -1) {
            action = this.mapping.get(url.substring(0, i));
            urlPara[0] = url.substring(i + 1);
        }
        return action;
    }

    public List<String> getAllActionKeys() {
        ArrayList<String> allActionKeys = new ArrayList<String>(this.mapping.keySet());
        Collections.sort(allActionKeys);
        return allActionKeys;
    }
}

