/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core.paragetter;

import com.jfinal.core.Controller;
import com.jfinal.core.paragetter.BeanGetter;
import com.jfinal.core.paragetter.BigDecimalGetter;
import com.jfinal.core.paragetter.BigIntegerGetter;
import com.jfinal.core.paragetter.BooleanGetter;
import com.jfinal.core.paragetter.DateGetter;
import com.jfinal.core.paragetter.DoubleGetter;
import com.jfinal.core.paragetter.EnumGetter;
import com.jfinal.core.paragetter.FileGetter;
import com.jfinal.core.paragetter.FloatGetter;
import com.jfinal.core.paragetter.IParaGetter;
import com.jfinal.core.paragetter.IntegerArrayGetter;
import com.jfinal.core.paragetter.IntegerGetter;
import com.jfinal.core.paragetter.LongArrayGetter;
import com.jfinal.core.paragetter.LongGetter;
import com.jfinal.core.paragetter.ModelGetter;
import com.jfinal.core.paragetter.Para;
import com.jfinal.core.paragetter.ParaGetter;
import com.jfinal.core.paragetter.ParaProcessor;
import com.jfinal.core.paragetter.RawPostData;
import com.jfinal.core.paragetter.RawPostDataGetter;
import com.jfinal.core.paragetter.ShortGetter;
import com.jfinal.core.paragetter.SqlDateGetter;
import com.jfinal.core.paragetter.StringArrayGetter;
import com.jfinal.core.paragetter.StringGetter;
import com.jfinal.core.paragetter.TimeGetter;
import com.jfinal.core.paragetter.TimestampGetter;
import com.jfinal.core.paragetter.UploadFileGetter;
import com.jfinal.kit.LogKit;
import com.jfinal.plugin.activerecord.IBean;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.upload.UploadFile;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class ParaProcessorBuilder {
    private static final ParaProcessorBuilder me = new ParaProcessorBuilder();
    private Map<Class<?>, Holder> typeMap = new HashMap();

    private ParaProcessorBuilder() {
        this.regist(Short.TYPE, ShortGetter.class, "0");
        this.regist(Integer.TYPE, IntegerGetter.class, "0");
        this.regist(Long.TYPE, LongGetter.class, "0");
        this.regist(Float.TYPE, FloatGetter.class, "0");
        this.regist(Double.TYPE, DoubleGetter.class, "0");
        this.regist(Boolean.TYPE, BooleanGetter.class, "false");
        this.regist(Short.class, ShortGetter.class, null);
        this.regist(Integer.class, IntegerGetter.class, null);
        this.regist(Long.class, LongGetter.class, null);
        this.regist(Float.class, FloatGetter.class, null);
        this.regist(Double.class, DoubleGetter.class, null);
        this.regist(Boolean.class, BooleanGetter.class, null);
        this.regist(String.class, StringGetter.class, null);
        this.regist(java.util.Date.class, DateGetter.class, null);
        this.regist(Date.class, SqlDateGetter.class, null);
        this.regist(Time.class, TimeGetter.class, null);
        this.regist(Timestamp.class, TimestampGetter.class, null);
        this.regist(BigDecimal.class, BigDecimalGetter.class, null);
        this.regist(BigInteger.class, BigIntegerGetter.class, null);
        this.regist(File.class, FileGetter.class, null);
        this.regist(UploadFile.class, UploadFileGetter.class, null);
        this.regist(String[].class, StringArrayGetter.class, null);
        this.regist(Integer[].class, IntegerArrayGetter.class, null);
        this.regist(Long[].class, LongArrayGetter.class, null);
        this.regist(RawPostData.class, RawPostDataGetter.class, null);
    }

    public static ParaProcessorBuilder me() {
        return me;
    }

    public <T> void regist(Class<T> typeClass, Class<? extends ParaGetter<T>> pgClass, String defaultValue) {
        this.typeMap.put(typeClass, new Holder(pgClass, defaultValue));
    }

    public ParaProcessor build(Class<? extends Controller> controllerClass, Method method) {
        int parameterCount = method.getParameterCount();
        ParaProcessor opag = new ParaProcessor(parameterCount);
        if (0 == parameterCount) {
            return opag;
        }
        for (Parameter p : method.getParameters()) {
            IParaGetter<?> pg = this.createParaGetter(controllerClass, method, p);
            if (pg instanceof FileGetter) {
                opag.addParaGetterToHeader(pg);
                continue;
            }
            opag.addParaGetter(pg);
        }
        return opag;
    }

    private IParaGetter<?> createParaGetter(Class<? extends Controller> controllerClass, Method method, Parameter p) {
        Holder holder;
        if (!p.isNamePresent()) {
            LogKit.warn("you should add compiler flag -parameters to support parameter auto binding");
        }
        String parameterName = p.getName();
        String defaultValue = null;
        Class<?> typeClass = p.getType();
        Para para = p.getAnnotation(Para.class);
        if (para != null) {
            parameterName = para.value().trim();
            defaultValue = para.defaultValue().trim();
            if (defaultValue.isEmpty()) {
                defaultValue = null;
            }
        }
        if ((holder = this.typeMap.get(typeClass)) != null) {
            if (null == defaultValue) {
                defaultValue = holder.getDefaultValue();
            }
            try {
                return holder.born(parameterName, defaultValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (Enum.class.isAssignableFrom(typeClass)) {
            return new EnumGetter(typeClass, parameterName, defaultValue);
        }
        if (IBean.class.isAssignableFrom(typeClass)) {
            return new BeanGetter(typeClass, parameterName);
        }
        if (Model.class.isAssignableFrom(typeClass)) {
            return new ModelGetter(typeClass, parameterName);
        }
        return new BeanGetter(typeClass, parameterName);
    }

    private static class Holder {
        private final String defaultValue;
        private final Class<? extends ParaGetter<?>> clazz;

        Holder(Class<? extends ParaGetter<?>> clazz, String defaultValue) {
            this.clazz = clazz;
            this.defaultValue = defaultValue;
        }

        final String getDefaultValue() {
            return this.defaultValue;
        }

        ParaGetter<?> born(String parameterName, String defaultValue) throws Exception {
            Constructor<ParaGetter<?>> con = this.clazz.getConstructor(String.class, String.class);
            return con.newInstance(parameterName, defaultValue);
        }
    }
}

