/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.expr.ast.MethodInfo;
import com.jfinal.template.expr.ast.MethodKit;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.lang.reflect.InvocationTargetException;

public class Method
extends Expr {
    private Expr expr;
    private String methodName;
    private ExprList exprList;

    public Method(Expr expr, String methodName, ExprList exprList, Location location) {
        if (exprList == null || exprList.length() == 0) {
            throw new ParseException("The parameter of method can not be blank", location);
        }
        this.init(expr, methodName, exprList, location);
    }

    public Method(Expr expr, String methodName, Location location) {
        this.init(expr, methodName, ExprList.NULL_EXPR_LIST, location);
    }

    private void init(Expr expr, String methodName, ExprList exprList, Location location) {
        if (expr == null) {
            throw new ParseException("The target for method invoking can not be blank", location);
        }
        if (MethodKit.isForbiddenMethod(methodName)) {
            throw new ParseException("Forbidden method: " + methodName, location);
        }
        this.expr = expr;
        this.methodName = methodName;
        this.exprList = exprList;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        MethodInfo methodInfo;
        Object target = this.expr.eval(scope);
        if (target == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            throw new TemplateException("The target for method invoking can not be null, method name: " + this.methodName, this.location);
        }
        Object[] argValues = this.exprList.evalExprList(scope);
        try {
            methodInfo = MethodKit.getMethod(target.getClass(), this.methodName, argValues);
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
        if (methodInfo == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            throw new TemplateException(Method.buildMethodNotFoundSignature("Method not found: " + target.getClass().getName() + ".", this.methodName, argValues), this.location);
        }
        try {
            return methodInfo.invoke(target, argValues);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t != null) {
                throw new TemplateException(t.getMessage(), this.location, t);
            }
            throw new TemplateException(e.getMessage(), this.location, e);
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }

    static String buildMethodNotFoundSignature(String preMsg, String methodName, Object[] argValues) {
        StringBuilder ret = new StringBuilder().append(preMsg).append(methodName).append("(");
        if (argValues != null) {
            for (int i = 0; i < argValues.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(argValues[i] != null ? argValues[i].getClass().getName() : "null");
            }
        }
        return ret.append(")").toString();
    }
}

