package com.jfireframework.codejson.function.impl.write.array;

import com.jfireframework.baseutil.collection.StringCache;
import com.jfireframework.codejson.function.impl.write.WriterAdapter;
import com.jfireframework.codejson.tracker.Tracker;

public class FloatArrayWriter extends WriterAdapter
{
    @Override
    public void write(Object field, StringCache cache, Object entity, Tracker tracker)
    {
        float[] array = (float[]) field;
        cache.append('[');
        for (float each : array)
        {
            cache.append(each).append(',');
        }
        if (cache.isCommaLast())
        {
            cache.deleteLast();
        }
        cache.append(']');
    }
}
