/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.codejson.function;

import com.jfireframework.baseutil.collection.StringCache;
import com.jfireframework.baseutil.reflect.ReflectUtil;
import com.jfireframework.baseutil.smc.SmcHelper;
import com.jfireframework.baseutil.smc.compiler.JavaStringCompiler;
import com.jfireframework.baseutil.smc.model.CompilerModel;
import com.jfireframework.baseutil.smc.model.FieldModel;
import com.jfireframework.baseutil.smc.model.MethodModel;
import com.jfireframework.codejson.JsonArray;
import com.jfireframework.codejson.JsonObject;
import com.jfireframework.codejson.annotation.JsonIgnore;
import com.jfireframework.codejson.function.JsonReader;
import com.jfireframework.codejson.function.ReadStrategy;
import com.jfireframework.codejson.function.Strategy;
import com.jfireframework.codejson.function.impl.read.DateReader;
import com.jfireframework.codejson.function.impl.read.FileReader;
import com.jfireframework.codejson.function.impl.read.ObjectReader;
import com.jfireframework.codejson.function.impl.read.array.BooleanArrayReader;
import com.jfireframework.codejson.function.impl.read.array.ByteArrayReader;
import com.jfireframework.codejson.function.impl.read.array.CharArrayReader;
import com.jfireframework.codejson.function.impl.read.array.DoubleArrayReader;
import com.jfireframework.codejson.function.impl.read.array.FloatArrayReader;
import com.jfireframework.codejson.function.impl.read.array.IntArrayReader;
import com.jfireframework.codejson.function.impl.read.array.LongArrayReader;
import com.jfireframework.codejson.function.impl.read.array.ShortArrayReader;
import com.jfireframework.codejson.function.impl.read.array.StringArrayReader;
import com.jfireframework.codejson.function.impl.read.wrapper.BooleanReader;
import com.jfireframework.codejson.function.impl.read.wrapper.ByteReader;
import com.jfireframework.codejson.function.impl.read.wrapper.CharacterReader;
import com.jfireframework.codejson.function.impl.read.wrapper.DoubleReader;
import com.jfireframework.codejson.function.impl.read.wrapper.FloatReader;
import com.jfireframework.codejson.function.impl.read.wrapper.IntegerReader;
import com.jfireframework.codejson.function.impl.read.wrapper.LongReader;
import com.jfireframework.codejson.function.impl.read.wrapper.ShortReader;
import com.jfireframework.codejson.function.impl.read.wrapper.StringReader;
import com.jfireframework.codejson.methodinfo.MethodInfoBuilder;
import com.jfireframework.codejson.methodinfo.ReadMethodInfo;
import com.jfireframework.codejson.util.MethodComparator;
import com.jfireframework.codejson.util.NameTool;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderContext {
    private static ConcurrentMap<Type, JsonReader> readerMap = new ConcurrentHashMap<Type, JsonReader>();
    private static Set<Class<?>> wrapperSet = new HashSet();
    private static final Logger logger = LoggerFactory.getLogger(ReaderContext.class);
    private static final AtomicInteger count = new AtomicInteger(1);

    public static Object read(Type entityType, Object value) {
        return ReaderContext.getReader(entityType).read(entityType, value);
    }

    public static JsonReader getReader(Type ckass) {
        JsonReader reader = (JsonReader)readerMap.get(ckass);
        if (reader == null) {
            try {
                reader = (JsonReader)ReaderContext.createReader(ckass, null).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            readerMap.put(ckass, reader);
        }
        return reader;
    }

    protected static JsonReader getReader(Type ckass, ReadStrategy readStrategy) {
        try {
            return (JsonReader)ReaderContext.createReader(ckass, readStrategy).getConstructor(ReadStrategy.class).newInstance(readStrategy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static Class<?> createReader(Type type, ReadStrategy strategy) {
        String body = null;
        if (type instanceof Class) {
            Class tmp = (Class)type;
            if (tmp.isArray()) {
                body = ReaderContext.buildArrayReader(tmp);
            } else {
                StringCache stringCache = new StringCache();
                stringCache.append("{\r\n" + SmcHelper.getTypeName((Class)tmp) + " entity = new " + SmcHelper.getTypeName((Class)tmp) + "();\r\n");
                stringCache.append("JsonObject json = (JsonObject)$1;\r\n");
                Method[] methods = ReflectUtil.listSetMethod((Class)tmp);
                Arrays.sort(methods, new MethodComparator());
                for (Method each : methods) {
                    if (ReaderContext.needIgnore(each, strategy)) continue;
                    ReadMethodInfo methodInfo = MethodInfoBuilder.buildReadMethodInfo(each, strategy);
                    stringCache.append(methodInfo.getOutput());
                }
                stringCache.append("return entity;\r\n}");
                body = stringCache.toString();
            }
            return ReaderContext.buildClass(body, tmp, strategy);
        }
        if (type instanceof ParameterizedType) {
            Class targetClass = (Class)((ParameterizedType)type).getRawType();
            if (targetClass.isInterface() || Modifier.isAbstract(targetClass.getModifiers())) {
                throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u9700\u8981\u5177\u4f53\u7684\u7c7b\u4fe1\u606f\uff0c\u4e0d\u80fd\u662f\u63a5\u53e3\u6216\u8005\u662f\u62bd\u8c61\u7c7b");
            }
            if (Collection.class.isAssignableFrom(targetClass)) {
                Type paramType = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (type instanceof WildcardType) {
                    throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u4e0d\u80fd\u4f7f\u7528\uff1f\u6cdb\u578b\u53c2\u6570");
                }
                body = ReaderContext.buildCollectionReader(targetClass, paramType);
            } else if (Map.class.isAssignableFrom(targetClass)) {
                Type keyType = ((ParameterizedType)type).getActualTypeArguments()[0];
                Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
                if (keyType instanceof WildcardType || valueType instanceof WildcardType) {
                    throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u4e0d\u80fd\u4f7f\u7528\uff1f\u6cdb\u578b\u53c2\u6570");
                }
                body = ReaderContext.buildMapReader(targetClass, keyType, valueType);
            }
            return ReaderContext.buildClass(body, targetClass, strategy);
        }
        if (type instanceof GenericArrayType) {
            Type root = type;
            while (root instanceof GenericArrayType) {
                root = ((GenericArrayType)root).getGenericComponentType();
            }
            if (root instanceof WildcardType) {
                throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u9700\u8981\u786e\u5b9a\u7684\u4fe1\u606f\uff0c\u4e0d\u80fd\u4f7f\u7528\uff1f\u6cdb\u578b\u53c2\u6570");
            }
            body = ReaderContext.buildArrayReader(type);
            if (root instanceof ParameterizedType) {
                root = ((ParameterizedType)root).getRawType();
            }
            return ReaderContext.buildClass(body, (Class)root, strategy);
        }
        if (type instanceof WildcardType) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u9700\u8981\u786e\u5b9a\u7684\u4fe1\u606f\uff0c\u4e0d\u80fd\u4f7f\u7528\uff1f\u6cdb\u578b\u53c2\u6570");
        }
        throw new RuntimeException("\u672a\u77e5\u60c5\u51b5");
    }

    private static Class<?> buildClass(String body, Class<?> targetClass, ReadStrategy strategy) {
        CompilerModel compilerModel = new CompilerModel("JsonReader_reader_" + count.getAndIncrement(), Object.class, new Class[]{JsonReader.class});
        try {
            if (strategy != null) {
                ReaderContext.createStrategyConstructor(compilerModel);
            }
            MethodModel methodModel = new MethodModel(JsonReader.class.getMethods()[0]);
            methodModel.setBody(body);
            compilerModel.putMethod(JsonReader.class.getMethods()[0], methodModel);
            compilerModel.addImport(new Class[]{JsonArray.class, JsonObject.class, ReaderContext.class, ReadStrategy.class, Strategy.class, Iterator.class});
            logger.trace("\u4e3a\u76ee\u6807\u7c7b{}\u751f\u6210\u7684\u8bfb\u53d6json\u7684\u6e90\u7801\u662f\n{}\r\n", (Object)targetClass.getName(), (Object)compilerModel.toStringWithLineNo());
            JavaStringCompiler compiler = new JavaStringCompiler();
            return compiler.compile(compilerModel, targetClass.getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void createStrategyConstructor(CompilerModel model) {
        model.addField(new FieldModel[]{new FieldModel("readStrategy", ReadStrategy.class)});
        model.addConstructor("this.readStrategy = $0;", new Class[]{ReadStrategy.class});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildArrayReader(Type targetClass) {
        int i;
        String rootName = null;
        int dim = 0;
        if (targetClass instanceof Class) {
            Class<?> rootType = (Class<?>)targetClass;
            dim = 0;
            while (rootType.isArray()) {
                ++dim;
                rootType = rootType.getComponentType();
            }
            rootName = rootType.getName();
        } else {
            Type root = targetClass;
            dim = 0;
            while (root instanceof GenericArrayType) {
                ++dim;
                root = ((GenericArrayType)root).getGenericComponentType();
            }
            if (root instanceof ParameterizedType) {
                if (!((root = ((ParameterizedType)root).getRawType()) instanceof Class)) throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u9700\u8981\u7684\u7c7b\u5b9a\u4e49\u4fe1\u606f\u4e0d\u660e\u786e");
                rootName = ((Class)root).getName();
            } else {
                rootName = ((Class)root).getName();
            }
        }
        String str = "{\r\n\tJsonArray jsonArray" + dim + " = ((JsonArray)$1);\r\n";
        str = str + "\tint l" + dim + " = jsonArray" + dim + ".size();\r\n";
        str = str + "\t" + NameTool.buildDimTypeName(rootName, dim) + " array" + dim + " = " + NameTool.buildNewDimTypeName(rootName, dim, "l" + dim) + ";\r\n";
        str = str + "\tfor(int i" + dim + " = 0;i" + dim + "<l" + dim + ";i" + dim + "++)\r\n";
        str = str + "\t{\r\n";
        String bk = "\t\t";
        for (i = dim - 1; i > 0; --i) {
            str = str + bk + "JsonArray jsonArray" + i + " =jsonArray" + (i + 1) + ".getJsonArray(i" + (i + 1) + ");\r\n";
            str = str + bk + "int l" + i + " = jsonArray" + i + ".size();\r\n";
            str = str + bk + NameTool.buildDimTypeName(rootName, i) + " array" + i + " = " + NameTool.buildNewDimTypeName(rootName, i, "l" + i) + ";\r\n";
            str = str + bk + "for(int i" + i + " = 0;i" + i + "<l" + i + ";i" + i + "++)\r\n";
            str = str + bk + "{\r\n";
            bk = bk + "\t";
        }
        if (!(targetClass instanceof Class)) throw new RuntimeException("javassist\u4e0d\u652f\u6301\u6cdb\u578b\u53c2\u6570\uff0c\u65e0\u6cd5\u5b8c\u6210\u8be5\u5bf9\u8c61\u7684");
        str = str + bk + "array1[i1] = (" + rootName + ")ReaderContext.read(" + rootName + ".class,jsonArray1.get(i1));\r\n";
        for (i = 1; i <= dim - 1; ++i) {
            bk = bk.substring(0, bk.length() - 1);
            str = str + bk + "}\r\n";
            str = str + bk + "array" + (i + 1) + "[i" + (i + 1) + "] = array" + i + ";\r\n";
        }
        str = str + "\t}\r\n";
        str = str + "\treturn array" + dim + ";\r\n";
        return str + "}";
    }

    private static String buildCollectionReader(Class<?> collectionClass, Type paramType) {
        String str = "{\r\n\t" + collectionClass.getName() + " collection = new " + collectionClass.getName() + "();\r\n";
        str = str + "\tJsonArray jsonArray = (JsonArray)$1;\r\n";
        str = str + "\tint size = jsonArray.size();\r\n";
        str = str + "\tfor(int i=0;i<size;i++)\r\n";
        str = str + "\t{\r\n";
        if (wrapperSet.contains(paramType)) {
            str = str + "\t\tcollection.add(jsonArray.getW" + ((Class)paramType).getSimpleName() + "(i));\r\n";
        } else if (paramType instanceof Class) {
            str = str + "\t\tcollection.add(ReaderContext.read(" + ((Class)paramType).getName() + ".class,jsonArray.get(i)));\r\n";
        } else if (paramType instanceof Type) {
            str = str + "\t\tcollection.add(ReaderContext.read(new TypeUtil<" + String.valueOf(paramType) + ">(){}.getType(),jsonArray.get(i));\r\n";
        } else {
            throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
        }
        str = str + "\t}\r\n";
        str = str + "\treturn collection;\r\n";
        str = str + "}";
        return str;
    }

    private static String buildMapReader(Class<?> mapClass, Type keyType, Type valueType) {
        Class tmp;
        String str = "{\r\n\t" + mapClass.getName() + " map = new " + mapClass.getName() + "();\r\n";
        str = str + "\tJsonObject jsonObject = (JsonObject)$1;\r\n";
        str = str + "\tint size = jsonObject.size();\r\n";
        str = str + "\tIterator it = jsonObject.entrySet().iterator();\r\n";
        str = str + "\tObject key = null;\r\n";
        str = str + "\tObject value = null;\r\n";
        str = str + "\twhile(it.hasNext())\r\n";
        str = str + "\t{\r\n";
        str = str + "\t\tjava.util.Map.Entry each = (java.util.Map.Entry)it.next();\r\n";
        if (keyType instanceof Class) {
            str = ((Class)keyType).equals(String.class) ? str + "\t\tkey = (String)each.getKey();\r\n" : (((Class)keyType).equals(Character.class) ? str + "\t\tkey = ((String)each.getKey()).charAt(0);\r\n" : (wrapperSet.contains(keyType) ? str + "\t\tkey = " + ((Class)keyType).getName() + ".valueOf((String)each.getKey());\r\n" : str + "\t\tkey = ReaderContext.read(" + ((Class)keyType).getName() + ".class,(String)each.getKey());\r\n"));
        } else {
            throw new RuntimeException("\u6682\u65f6\u8d85\u51fa\u5904\u7406\u903b\u8f91\uff0c\u8bf7\u53d1\u90ae\u4ef6\u7ed9\u4f5c\u8005eric@jfire.cn");
        }
        str = valueType instanceof Class ? ((tmp = (Class)valueType).equals(String.class) ? str + "\t\tvalue = (String)each.getValue();\r\n" : (tmp.equals(Character.class) ? str + "\t\tvalue = ((String)each.getValue()).charAt(0);\r\n" : (wrapperSet.contains(tmp) ? str + "\t\tvalue = jsonObject.getW" + tmp.getSimpleName() + "(each.getKey());\r\n" : str + "\t\tvalue = ReaderContext.read(" + tmp.getName() + ".class,each.getValue());\r\n"))) : str + "\t\tvalue = ReaderContext.read(new TypeUtil<" + String.valueOf(valueType) + ">(){}.getType(),each.getValue());\r\n";
        str = str + "\t\tmap.put(key,value);\r\n";
        str = str + "\t}\r\n";
        str = str + "\treturn map;";
        str = str + "}";
        return str;
    }

    public static void putReader(Class<?> ckass, JsonReader jsonReader) {
        readerMap.put(ckass, jsonReader);
    }

    private static boolean needIgnore(Method method, ReadStrategy strategy) {
        String fieldName = ReflectUtil.getFieldNameFromMethod((Method)method);
        if (method.isAnnotationPresent(JsonIgnore.class) && method.getAnnotation(JsonIgnore.class).force()) {
            return true;
        }
        if (strategy != null) {
            return strategy.ignore(method.getDeclaringClass().getName() + '.' + fieldName);
        }
        if (method.isAnnotationPresent(JsonIgnore.class)) {
            return true;
        }
        try {
            Field field = method.getDeclaringClass().getDeclaredField(fieldName);
            return field.isAnnotationPresent(JsonIgnore.class);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        readerMap.put((Type)((Object)Boolean.class), new BooleanReader());
        readerMap.put((Type)((Object)Byte.class), new ByteReader());
        readerMap.put((Type)((Object)Character.class), new CharacterReader());
        readerMap.put((Type)((Object)Double.class), new DoubleReader());
        readerMap.put((Type)((Object)Float.class), new FloatReader());
        readerMap.put((Type)((Object)Integer.class), new IntegerReader());
        readerMap.put((Type)((Object)Long.class), new LongReader());
        readerMap.put((Type)((Object)Short.class), new ShortReader());
        readerMap.put((Type)((Object)String.class), new StringReader());
        readerMap.put((Type)((Object)int[].class), new IntArrayReader());
        readerMap.put((Type)((Object)byte[].class), new ByteArrayReader());
        readerMap.put((Type)((Object)boolean[].class), new BooleanArrayReader());
        readerMap.put((Type)((Object)char[].class), new CharArrayReader());
        readerMap.put((Type)((Object)long[].class), new LongArrayReader());
        readerMap.put((Type)((Object)short[].class), new ShortArrayReader());
        readerMap.put((Type)((Object)float[].class), new FloatArrayReader());
        readerMap.put((Type)((Object)double[].class), new DoubleArrayReader());
        readerMap.put((Type)((Object)String[].class), new StringArrayReader());
        readerMap.put((Type)((Object)Object.class), new ObjectReader());
        readerMap.put((Type)((Object)Date.class), new DateReader());
        readerMap.put((Type)((Object)File.class), new FileReader());
    }
}

