/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.codejson.tracker;

import com.jfireframework.baseutil.collection.StringCache;

public class Tracker {
    private Object[] objs = new Object[10];
    private String[] paths = new String[10];
    private boolean[] isArray = new boolean[10];
    private int count = 0;
    private StringCache cache = new StringCache(128);

    public void clear() {
        for (int i = 0; i < this.objs.length; ++i) {
            this.objs[i] = null;
            this.paths[i] = null;
        }
        this.count = 0;
    }

    public void reset(int reIndex) {
        this.count = reIndex + 1;
    }

    public int put(Object obj, String path, boolean isArray) {
        if (this.count >= this.objs.length) {
            Object[] tmp1 = new Object[this.objs.length + 10];
            String[] tmp2 = new String[this.paths.length + 10];
            boolean[] tmp3 = new boolean[this.isArray.length + 10];
            System.arraycopy(this.objs, 0, tmp1, 0, this.count);
            System.arraycopy(this.paths, 0, tmp2, 0, this.count);
            System.arraycopy(this.isArray, 0, tmp3, 0, this.count);
            this.objs = tmp1;
            this.paths = tmp2;
            this.isArray = tmp3;
        }
        this.objs[this.count] = obj;
        this.paths[this.count] = path;
        this.isArray[this.count] = isArray;
        ++this.count;
        return this.count;
    }

    public int indexOf(Object obj) {
        for (int i = 0; i < this.count; ++i) {
            if (this.objs[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public String getPath(int index) {
        this.cache.clear();
        this.cache.append(this.paths[0]);
        for (int i = 1; i < index; ++i) {
            if (this.isArray[i]) {
                this.cache.append(this.paths[i]);
                continue;
            }
            this.cache.append('.').append(this.paths[i]);
        }
        return this.cache.toString();
    }
}

