/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.codejson.util;

import com.jfireframework.baseutil.reflect.ReflectUtil;
import com.jfireframework.codejson.annotation.JsonRename;
import com.jfireframework.codejson.function.Strategy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class NameTool {
    public static String getNameFromMethod(Method method, Strategy strategy) {
        String fieldName = ReflectUtil.getFieldNameFromMethod((Method)method);
        if (strategy != null) {
            if (strategy.containsRename(method.getDeclaringClass().getName() + '.' + fieldName)) {
                return strategy.getRename(method.getDeclaringClass().getName() + '.' + fieldName);
            }
            return fieldName;
        }
        if (method.isAnnotationPresent(JsonRename.class)) {
            JsonRename rename = method.getAnnotation(JsonRename.class);
            return rename.value();
        }
        try {
            Field field = method.getDeclaringClass().getDeclaredField(fieldName);
            if (field.isAnnotationPresent(JsonRename.class)) {
                return field.getAnnotation(JsonRename.class).value();
            }
            return fieldName;
        }
        catch (Exception e) {
            return fieldName;
        }
    }

    public static Class<?> getRootType(Class<?> type) {
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type;
    }

    public static String buildDimTypeName(String rootName, int dim) {
        for (int i = 0; i < dim; ++i) {
            rootName = rootName + "[]";
        }
        return rootName;
    }

    public static String buildNewDimTypeName(String rootName, int dim, String size) {
        String value = "new " + rootName + "[" + size + "]";
        --dim;
        for (int i = 0; i < dim; ++i) {
            value = value + "[]";
        }
        return value;
    }

    public static int getDimension(Class<?> type) {
        int dim = 0;
        while (type.isArray()) {
            ++dim;
            type = type.getComponentType();
        }
        return dim;
    }
}

