/*
 * Decompiled with CFR 0.152.
 */
package com.jijiancode.end.java;

import com.jijiancode.end.java.JJCodeException;
import com.jijiancode.end.java.VerifyState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class JJCode {
    private static final String JJCODE_URL = "https://api.jijiancode.com/api/s/third/verify_id";

    public static VerifyState verify(String appId, String userSecret, String mobile, String requestToken) throws JJCodeException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        params.put("mobile", mobile);
        params.put("id", requestToken);
        params.put("country_code", "86");
        return JJCode.request(JJCODE_URL, params, userSecret);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static VerifyState request(String url, Map<String, String> params, String userSecret) throws JJCodeException {
        params.put("r", String.valueOf(System.currentTimeMillis()));
        params.put("key", JJCode.createSign(params, userSecret));
        InputStream is = null;
        HttpURLConnection connection = null;
        try {
            JSONObject jsonObject;
            block16: {
                int code;
                URL uri = new URL(url);
                connection = (HttpURLConnection)uri.openConnection();
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setRequestMethod("POST");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(15000);
                connection.setChunkedStreamingMode(0);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.connect();
                String data = JJCode.map2Json(params);
                if (!JJCode.isEmpty(data)) {
                    PrintWriter out = new PrintWriter(connection.getOutputStream());
                    out.print(data);
                    out.close();
                }
                if ((code = connection.getResponseCode()) != 200) throw new JJCodeException("network error: " + connection.getResponseMessage());
                is = connection.getInputStream();
                String ss = JJCode.in2String(is);
                jsonObject = new JSONObject(ss);
                int dCode = jsonObject.getInt("code");
                if (dCode != 200) break block16;
                JSONObject dataJson = jsonObject.getJSONObject("data");
                VerifyState verifyState = new VerifyState();
                verifyState.setMsg(dataJson.getString("msg"));
                verifyState.setStatus(dataJson.getInt("status"));
                VerifyState verifyState2 = verifyState;
                return verifyState2;
                {
                    catch (JSONException jsonException) {
                        throw new JJCodeException("parse json data error.");
                    }
                }
            }
            try {
                String errMsg = jsonObject.getString("msg");
                throw new JJCodeException(errMsg);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JJCodeException("unknown error.");
            }
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static String map2Json(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return "{}";
        }
        try {
            JSONObject jo = new JSONObject();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (JJCode.isEmpty(entry.getValue())) continue;
                jo.put(entry.getKey(), (Object)entry.getValue());
            }
            return jo.toString();
        }
        catch (Exception e) {
            System.out.println("format params error. err=" + e.getMessage());
            return "{}";
        }
    }

    private static String createSign(Map<String, String> map, String token) {
        if (map == null || map.size() == 0) {
            return "";
        }
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String value = map.get(key);
            if (JJCode.isEmpty(value)) continue;
            sb.append(key).append("=").append(value);
            sb.append("&");
        }
        sb.append("token=").append(token);
        return JJCode.md5(sb.toString());
    }

    private static String in2String(InputStream in) throws IOException {
        String ss;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "utf-8"));
        StringBuilder sb = new StringBuilder();
        while ((ss = br.readLine()) != null) {
            sb.append(ss);
        }
        br.close();
        return sb.toString();
    }

    private static String md5(String s) {
        if (s == null || s.equals("") || s.equals("null")) {
            return "";
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(s.getBytes());
            String result = "";
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result = result + temp;
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.equals("") || s.equals("null");
    }
}

