/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder;

import com.jsonex.core.factory.InjectableInstance;
import com.jsonex.core.util.ClassUtil;
import com.jsonex.core.util.StringUtil;
import com.jsonex.jsoncoder.BeanCoderContext;
import com.jsonex.jsoncoder.BeanCoderException;
import com.jsonex.jsoncoder.ICoder;
import com.jsonex.jsoncoder.JSONCoderOption;
import com.jsonex.jsoncoder.coder.CoderArray;
import com.jsonex.jsoncoder.coder.CoderCollection;
import com.jsonex.jsoncoder.coder.CoderMap;
import com.jsonex.jsoncoder.coder.CoderObject;
import com.jsonex.treedoc.TDNode;
import com.jsonex.treedoc.TreeDoc;
import com.jsonex.treedoc.json.TDJSONWriter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public class BeanCoder {
    public static final InjectableInstance<BeanCoder> it = InjectableInstance.of(BeanCoder.class);
    private static final int MAX_OBJECTS = 10000;
    private static final int MAX_DEPTH = 50;
    public static final String ID_KEY = "$id";
    private static final String REF_KEY = "$ref";

    public static BeanCoder get() {
        return (BeanCoder)it.get();
    }

    public TDNode encode(Object obj) {
        return this.encode(obj, new BeanCoderContext(JSONCoderOption.global), null);
    }

    public TDNode encode(Object obj, BeanCoderContext context, Type type) {
        return this._encode(obj, context.reset(), type, new TreeDoc().getRoot());
    }

    public Object decode(TDNode obj, Type type) {
        return this.decode(obj, type, null, "", new BeanCoderContext(JSONCoderOption.global));
    }

    public <T> T decode(TDNode obj, T target) {
        return (T)this.decode(obj, target.getClass(), target, "", new BeanCoderContext(JSONCoderOption.global));
    }

    public <T> T deepClone(T src) {
        return (T)(src == null ? null : this.decode(this.encode(src), src.getClass()));
    }

    public <T> T deepCopyTo(T src, T target) {
        return src == null ? null : (T)this.decode(this.encode(src), target);
    }

    TDNode _encode(Object obj, BeanCoderContext ctx, Type type, TDNode target) {
        JSONCoderOption opt = ctx.getOption();
        int pathSize = ctx.objectPath.size();
        try {
            if (obj == null) {
                TDNode tDNode = target;
                return tDNode;
            }
            Class<?> cls = obj.getClass();
            if (obj.getClass().getName().startsWith("java.lang.reflect.") || cls == Object.class || cls == BigDecimal.class) {
                TDNode tDNode = target.setValue((Object)obj.toString());
                return tDNode;
            }
            if (ClassUtil.isSimpleType(cls)) {
                TDNode tDNode = target.setValue(obj);
                return tDNode;
            }
            if (opt.isClassSkipped(cls)) {
                TDNode tDNode = target;
                return tDNode;
            }
            ICoder<?> coder = opt.findCoder(cls);
            if (coder != null) {
                TDNode tDNode = coder.encode(obj, type, ctx, target);
                return tDNode;
            }
            Object eqWrapper = opt.getEqualsWrapper(obj);
            try {
                int p = ctx.objectPath.indexOf(eqWrapper);
                if (p >= 0) {
                    TDNode tDNode = BeanCoder.setRef(target, StringUtil.appendRepeatedly((StringBuilder)new StringBuilder(), (String)"../", (int)(p + 1)).toString());
                    return tDNode;
                }
            }
            catch (ClassCastException p) {
                // empty catch block
            }
            if (ctx.convertedObjects.size() > 10000 || ctx.objectPath.size() > 50) {
                TDNode p = target.setValue((Object)"[TRIMMED_DUE_TO_TOO_MANY_OBJECT]");
                return p;
            }
            TDNode orgResult = ctx.convertedObjects.get(eqWrapper);
            if (opt.dedupWithRef && orgResult != null) {
                String hash = (String)orgResult.getChildValue(ID_KEY);
                if (hash == null) {
                    hash = Long.toHexString(BeanCoder.abs(eqWrapper.hashCode()));
                    orgResult.createChild(ID_KEY).setValue((Object)hash);
                }
                TDNode tDNode = BeanCoder.setRef(target, "#" + hash);
                return tDNode;
            }
            if (!(obj instanceof Collection && ((Collection)obj).isEmpty() || obj instanceof Map && ((Map)obj).isEmpty())) {
                ctx.objectPath.push(eqWrapper);
            }
            if (cls.isArray()) {
                CoderArray.get().encode(obj, type, ctx, target);
            } else if (obj instanceof Collection) {
                CoderCollection.get().encode((Collection)obj, type, ctx, target);
            } else if (obj instanceof Map) {
                CoderMap.get().encode((Map)obj, type, ctx, target);
            } else {
                CoderObject.get().encode(obj, type, ctx, target);
            }
            if (target.getType() == TDNode.Type.MAP && target.hasChildren()) {
                ctx.convertedObjects.put(eqWrapper, target);
            }
            TDNode tDNode = target;
            return tDNode;
        }
        catch (Exception ex) {
            throw new BeanCoderException(ex);
        }
        finally {
            if (ctx.objectPath.size() > pathSize) {
                ctx.objectPath.pop();
            }
        }
    }

    private static TDNode setRef(TDNode node, String ref) {
        node.setType(TDNode.Type.MAP).createChild(REF_KEY).setValue((Object)ref);
        return node;
    }

    public Object decode(TDNode tdNode, Type type, Object targetObj, String name, BeanCoderContext ctx) {
        if (tdNode == null) {
            return null;
        }
        Class cls = ClassUtil.getGenericClass((Type)type);
        int pathSize = ctx.objectPath.size();
        try {
            Object p;
            Object refVal = tdNode.getChildValue(REF_KEY);
            if (refVal instanceof String) {
                String ref = (String)refVal;
                if (ref.length() > 0 && ref.charAt(0) == '#') {
                    Object object = ctx.hashToObjectMap.get(ref.substring(1));
                    return object;
                }
                int level = ref.length() / 3;
                if (ctx.objectPath.size() < level) {
                    throw new BeanCoderException("Reference level exceeding objectPath:" + ctx.objectPath + "; ref:" + ref);
                }
                Object object = ctx.objectPath.get(level - 1);
                return object;
            }
            if (tdNode.getType() == TDNode.Type.SIMPLE && (p = ClassUtil.objectToSimpleType((Object)tdNode.getValue(), (Class)cls)) != null) {
                Object object = p;
                return object;
            }
            ICoder<?> coder = ctx.option.findCoder(cls);
            if (coder != null) {
                Object obj = coder.decode(tdNode, type, targetObj, ctx);
                return obj;
            }
            if (cls == String.class) {
                String string = TDJSONWriter.get().writeAsString(tdNode);
                return string;
            }
            if (cls.isArray()) {
                Object object = CoderArray.get().decode(tdNode, type, targetObj, ctx);
                return object;
            }
            if (Collection.class.isAssignableFrom(cls)) {
                Collection collection = CoderCollection.get().decode(tdNode, type, targetObj, ctx);
                return collection;
            }
            if (Map.class.isAssignableFrom(cls)) {
                Map map = CoderMap.get().decode(tdNode, type, targetObj, ctx);
                return map;
            }
            Object object = CoderObject.get().decode(tdNode, type, targetObj, ctx);
            return object;
        }
        catch (Exception e) {
            throw new BeanCoderException("failed to decode:" + type + "; name=" + name, e);
        }
        finally {
            if (ctx.objectPath.size() > pathSize) {
                ctx.objectPath.pop();
            }
        }
    }

    private static int abs(int a) {
        return a < 0 ? -a : a;
    }
}

