/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder;

import com.jsonex.jsoncoder.BeanCoder;
import com.jsonex.jsoncoder.BeanCoderContext;
import com.jsonex.jsoncoder.BeanCoderException;
import com.jsonex.jsoncoder.DecodeReq;
import com.jsonex.jsoncoder.EncodeReq;
import com.jsonex.jsoncoder.JSONCoderOption;
import com.jsonex.treedoc.TDNode;
import com.jsonex.treedoc.TDPath;
import com.jsonex.treedoc.json.CharSource;
import com.jsonex.treedoc.json.TDJSONParser;
import com.jsonex.treedoc.json.TDJSONParserOption;
import com.jsonex.treedoc.json.TDJSONWriter;
import java.io.Reader;
import java.io.Writer;
import lombok.Generated;

public class JSONCoder {
    static final JSONCoder global = new JSONCoder(JSONCoderOption.global);
    final JSONCoderOption option;

    public JSONCoder(JSONCoderOption option) {
        this.option = option;
    }

    public static <T> T decode(DecodeReq<T> req, JSONCoderOption opt) {
        try {
            TDNode tdNode = req.tdNode;
            if (tdNode == null && req.source != null) {
                tdNode = TDJSONParser.get().parse(new TDJSONParserOption(req.source));
            }
            if (req.nodePath != null) {
                tdNode = tdNode.getByPath(TDPath.parse((String)req.nodePath));
            }
            if (tdNode == null) {
                return null;
            }
            return (T)BeanCoder.get().decode(tdNode, req.getType(), req.target, "", new BeanCoderContext(opt));
        }
        catch (Exception e) {
            if (e instanceof BeanCoderException) {
                throw (BeanCoderException)e;
            }
            throw new BeanCoderException(e);
        }
    }

    public static <T> T decode(String jsonStr, Class<T> type, JSONCoderOption opt) {
        return JSONCoder.decode(DecodeReq.of(type).setJson(jsonStr), opt);
    }

    public static <T> T decode(Reader reader, Class<T> type, JSONCoderOption opt) {
        return JSONCoder.decode(DecodeReq.of(type).setReader(reader), opt);
    }

    public static <T> T decode(CharSource source, Class<T> type, JSONCoderOption opt) {
        return JSONCoder.decode(DecodeReq.of(type).setSource(source), opt);
    }

    public static <T> T decode(TDNode treeDocNode, Class<T> type, JSONCoderOption opt) {
        return JSONCoder.decode(DecodeReq.of(type).setTdNode(treeDocNode), opt);
    }

    public <T> T decode(DecodeReq<T> req) {
        return JSONCoder.decode(req, this.option);
    }

    public <T> T decodeTo(String str, T target) {
        return this.decode(DecodeReq.of(target.getClass()).setJson(str).setTarget(target));
    }

    public <T> T decode(String str, Class<T> type) {
        return JSONCoder.decode(str, type, this.option);
    }

    public <T> T decode(Reader reader, Class<T> type) {
        return JSONCoder.decode(DecodeReq.of(type).setReader(reader), this.option);
    }

    public <T> T decode(CharSource source, Class<T> type) {
        return JSONCoder.decode(DecodeReq.of(type).setSource(source), this.option);
    }

    public <T> T decode(TDNode treeDocNode, Class<T> type) {
        return JSONCoder.decode(DecodeReq.of(type).setTdNode(treeDocNode), this.option);
    }

    public static String encode(EncodeReq req, JSONCoderOption opt) {
        try {
            StringBuilder sWriter = null;
            Appendable writer = req.writer;
            if (writer == null) {
                sWriter = new StringBuilder();
                writer = sWriter;
            }
            TDNode jsonNode = BeanCoder.get().encode(req.object, new BeanCoderContext(opt), req.type);
            TDJSONWriter.get().write(writer, jsonNode, opt.getJsonOption());
            return sWriter == null ? null : sWriter.toString();
        }
        catch (Exception e) {
            throw new BeanCoderException(e);
        }
    }

    public static String encode(Object obj, JSONCoderOption opt) {
        return JSONCoder.encode(EncodeReq.of(obj), opt);
    }

    public static void encode(Object obj, Writer writer, JSONCoderOption opt) {
        JSONCoder.encode(EncodeReq.of(obj).setWriter(writer), opt);
    }

    public String encode(EncodeReq req) {
        return JSONCoder.encode(req, this.option);
    }

    public String encode(Object obj) {
        return JSONCoder.encode(obj, this.option);
    }

    public void encode(Object obj, Writer writer) {
        JSONCoder.encode(obj, writer, this.option);
    }

    @Generated
    public static JSONCoder getGlobal() {
        return global;
    }

    @Generated
    public JSONCoderOption getOption() {
        return this.option;
    }
}

