/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder;

import com.jsonex.jsoncoder.IFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public class SimpleFilter
implements IFilter {
    private final Class<?> type;
    boolean include;
    private Set<String> properties = new HashSet<String>();

    private SimpleFilter(Class<?> type) {
        this.type = type;
    }

    public static SimpleFilter of(Class<?> type) {
        return new SimpleFilter(type);
    }

    @Override
    public Boolean isFieldSkipped(String field) {
        if (this.properties.contains(field)) {
            return !this.include;
        }
        if (this.include && !this.properties.contains(field)) {
            return true;
        }
        return null;
    }

    public SimpleFilter addProperties(String ... props) {
        this.properties.addAll(Arrays.asList(props));
        return this;
    }

    public SimpleFilter removeProperties(String ... props) {
        this.properties.removeAll(Arrays.asList(props));
        return this;
    }

    @Generated
    public SimpleFilter setProperties(Set<String> properties) {
        this.properties = properties;
        return this;
    }

    @Generated
    public Set<String> getProperties() {
        return this.properties;
    }

    @Override
    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @Generated
    public boolean isInclude() {
        return this.include;
    }

    @Generated
    public SimpleFilter setInclude(boolean include) {
        this.include = include;
        return this;
    }
}

