/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder.coder;

import com.jsonex.core.factory.InjectableInstance;
import com.jsonex.core.util.ClassUtil;
import com.jsonex.core.util.StringUtil;
import com.jsonex.jsoncoder.BeanCoderContext;
import com.jsonex.jsoncoder.BeanCoderException;
import com.jsonex.jsoncoder.ICoder;
import com.jsonex.treedoc.TDNode;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

public class CoderArray
implements ICoder<Object> {
    public static final InjectableInstance<CoderArray> it = InjectableInstance.of(CoderArray.class);

    public static CoderArray get() {
        return (CoderArray)it.get();
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @Override
    public TDNode encode(Object obj, Type type, BeanCoderContext ctx, TDNode target) {
        target.setType(TDNode.Type.ARRAY);
        Class cls = ClassUtil.getGenericClass((Type)type);
        for (int i = 0; i < Array.getLength(obj); ++i) {
            ctx.encode(Array.get(obj, i), cls.getComponentType(), target.createChild());
        }
        return target;
    }

    @Override
    public Object decode(TDNode jsonNode, Type type, Object targetObj, BeanCoderContext ctx) {
        if (jsonNode.getType() != TDNode.Type.ARRAY) {
            throw new BeanCoderException("Incorrect input, the input has to be an array:" + StringUtil.toTrimmedStr((Object)jsonNode, (int)500));
        }
        Class cls = ClassUtil.getGenericClass((Type)type);
        Object array = Array.newInstance(cls.getComponentType(), jsonNode.getChildren().size());
        ctx.getObjectPath().push(array);
        for (int i = 0; i < jsonNode.getChildrenSize(); ++i) {
            Array.set(array, i, ctx.decode(jsonNode.getChild(i), cls.getComponentType(), null, Integer.toString(i)));
        }
        return array;
    }
}

