/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder.coder;

import com.jsonex.core.factory.InjectableInstance;
import com.jsonex.core.util.ClassUtil;
import com.jsonex.core.util.StringUtil;
import com.jsonex.jsoncoder.BeanCoderContext;
import com.jsonex.jsoncoder.BeanCoderException;
import com.jsonex.jsoncoder.ICoder;
import com.jsonex.treedoc.TDNode;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class CoderCollection
implements ICoder<Collection> {
    public static final InjectableInstance<CoderCollection> it = InjectableInstance.of(CoderCollection.class);

    public static CoderCollection get() {
        return (CoderCollection)it.get();
    }

    @Override
    public Class<Collection> getType() {
        return Collection.class;
    }

    @Override
    public TDNode encode(Collection obj, Type type, BeanCoderContext ctx, TDNode target) {
        target.setType(TDNode.Type.ARRAY);
        Type[] actualTypeParameters = ClassUtil.getGenericTypeActualParams((Type)type);
        Type childType = null;
        if (actualTypeParameters != null) {
            childType = actualTypeParameters[0];
        }
        for (Object o1 : obj) {
            ctx.encode(o1, childType, target.createChild(null));
        }
        return target;
    }

    @Override
    public Collection decode(TDNode jsonNode, Type type, Object targetObj, BeanCoderContext ctx) {
        if (jsonNode.getType() != TDNode.Type.ARRAY) {
            throw new BeanCoderException("Incorrect input, the input has to be an array:" + StringUtil.toTrimmedStr((Object)jsonNode, (int)500));
        }
        Class cls = ClassUtil.getGenericClass((Type)type);
        Type[] actualTypeParameters = ClassUtil.getGenericTypeActualParams((Type)type);
        if (actualTypeParameters == null) {
            throw new BeanCoderException("For collection type, you have to specify the actual type: " + cls);
        }
        Type childType = actualTypeParameters[0];
        Collection<Object> result = (EnumSet<Object>)targetObj;
        if (result == null) {
            int modifier = cls.getModifiers();
            result = Modifier.isAbstract(modifier) || Modifier.isInterface(modifier) ? (EnumSet.class.isAssignableFrom(cls) ? EnumSet.noneOf((Class)childType) : (Set.class.isAssignableFrom(cls) ? new HashSet() : new ArrayList())) : (Collection)cls.newInstance();
        }
        ctx.getObjectPath().push(result);
        for (int i = 0; i < jsonNode.getChildrenSize(); ++i) {
            result.add(ctx.decode((TDNode)jsonNode.getChildren().get(i), childType, null, Integer.toString(i)));
        }
        return result;
    }
}

