/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder.coder;

import com.jsonex.core.type.Identifiable;
import com.jsonex.core.util.ClassUtil;
import com.jsonex.core.util.EnumUtil;
import com.jsonex.jsoncoder.BeanCoderContext;
import com.jsonex.jsoncoder.ICoder;
import com.jsonex.treedoc.TDNode;
import java.lang.reflect.Type;

public class CoderEnum
implements ICoder<Enum> {
    @Override
    public Class<Enum> getType() {
        return Enum.class;
    }

    @Override
    public TDNode encode(Enum obj, Type type, BeanCoderContext context, TDNode target) {
        return target.setValue(this.encode(obj, context));
    }

    private Object encode(Enum obj, BeanCoderContext context) {
        if (obj instanceof Identifiable) {
            Identifiable id = (Identifiable)obj;
            if (context.getOption().isShowEnumName()) {
                return id.getId() + "-" + obj.toString();
            }
            return id.getId();
        }
        return obj.toString();
    }

    @Override
    public Enum decode(TDNode jsonNode, Type type, Object targetObj, BeanCoderContext context) {
        Integer intValue;
        String strValue = null;
        Object obj = jsonNode.getValue();
        if (obj instanceof Integer) {
            intValue = (Integer)obj;
        } else {
            strValue = (String)obj;
            int p = strValue.indexOf(45);
            if (p >= 0) {
                strValue = strValue.substring(0, p).trim();
            }
            try {
                intValue = Integer.valueOf(strValue);
            }
            catch (NumberFormatException e) {
                intValue = null;
            }
        }
        Class cls = ClassUtil.getGenericClass((Type)type);
        if (intValue != null) {
            return CoderEnum.getEnumByInt(cls, intValue);
        }
        return CoderEnum.getEnumByString(cls, strValue);
    }

    private static Enum<?> getEnumByInt(Class cls, int i) {
        if (Identifiable.class.isAssignableFrom(cls)) {
            return EnumUtil.getEnumById((Class)cls, (Object)i);
        }
        return (Enum)cls.getEnumConstants()[i];
    }

    private static Enum getEnumByString(Class cls, String i) {
        Enum value;
        if (Identifiable.class.isAssignableFrom(cls) && (value = EnumUtil.getEnumByIdString((Class)cls, (String)i)) != null) {
            return value;
        }
        return EnumUtil.valueOf((Class)cls, (String)i);
    }
}

