/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder.coder;

import com.jsonex.core.factory.InjectableInstance;
import com.jsonex.core.util.BeanConvertContext;
import com.jsonex.core.util.ClassUtil;
import com.jsonex.core.util.StringUtil;
import com.jsonex.jsoncoder.BeanCoderContext;
import com.jsonex.jsoncoder.BeanCoderException;
import com.jsonex.jsoncoder.ICoder;
import com.jsonex.jsoncoder.JSONCoderOption;
import com.jsonex.treedoc.TDNode;
import com.jsonex.treedoc.json.TDJSONWriter;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public class CoderMap
implements ICoder<Map> {
    public static final InjectableInstance<CoderMap> it = InjectableInstance.of(CoderMap.class);
    private static final CoderMap instance = new CoderMap();

    public static CoderMap get() {
        return (CoderMap)it.get();
    }

    @Override
    public Class<Map> getType() {
        return Map.class;
    }

    @Override
    public TDNode encode(Map obj, Type type, BeanCoderContext ctx, TDNode target) {
        Class<Object> childKeyCls;
        JSONCoderOption opt = ctx.getOption();
        Map map = obj;
        Type[] actualTypeParameters = ClassUtil.getGenericTypeActualParams((Type)type);
        Type childKeyType = null;
        Type childValueType = null;
        if (actualTypeParameters != null) {
            childKeyType = actualTypeParameters[0];
            childValueType = actualTypeParameters[1];
        }
        if ((childKeyCls = ClassUtil.getGenericClass(childKeyType)) == null) {
            childKeyCls = Object.class;
        }
        if (ClassUtil.isSimpleType(childKeyCls) || Enum.class.isAssignableFrom(childKeyCls) || childKeyCls == Object.class || opt.isAlwaysMapKeyAsString()) {
            target.setType(TDNode.Type.MAP);
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                ctx.encode(entry.getValue(), childValueType, target.createChild(key));
            }
            return target;
        }
        if (map.entrySet() != null) {
            target.setType(TDNode.Type.ARRAY);
            TDNode child = target.createChild(null);
            for (Map.Entry entry : map.entrySet()) {
                LinkedHashMap entryMap = new LinkedHashMap(2);
                ctx.encode(entry.getKey(), childKeyType, child.createChild("key"));
                ctx.encode(entry.getValue(), childValueType, child.createChild("value"));
            }
        }
        return target;
    }

    @Override
    public Map decode(TDNode jsonNode, Type type, Object targetObj, BeanCoderContext ctx) {
        Class cls = ClassUtil.getGenericClass((Type)type);
        Type[] actualTypeParameters = ClassUtil.getGenericTypeActualParams((Type)type);
        if (actualTypeParameters == null) {
            throw new BeanCoderException("BeanCoder: For Map type, you have to specify the actual key, value type: " + cls);
        }
        Type childKeyType = actualTypeParameters[0];
        Type childValueType = actualTypeParameters[1];
        Map result = (LinkedHashMap)targetObj;
        if (result == null) {
            int modifier = cls.getModifiers();
            result = Modifier.isAbstract(modifier) || Modifier.isInterface(modifier) ? new LinkedHashMap() : (Map)cls.newInstance();
        }
        ctx.getObjectPath().push(result);
        switch (jsonNode.getType()) {
            case MAP: {
                String hash = (String)jsonNode.getChildValue("$id");
                if (hash != null) {
                    ctx.getHashToObjectMap().put(hash, result);
                }
                for (int i = 0; i < jsonNode.getChildrenSize(); ++i) {
                    TDNode cn = jsonNode.getChild(i);
                    Object key = ClassUtil.stringToSimpleObject((String)cn.getKey(), (Class)ClassUtil.getGenericClass((Type)childKeyType), (BeanConvertContext)new BeanConvertContext());
                    Object value = ctx.decode(cn, childValueType, result.get(key), i + ".value");
                    result.put(key, value);
                }
                return result;
            }
            case ARRAY: {
                for (int i = 0; i < jsonNode.getChildrenSize(); ++i) {
                    TDNode cn = jsonNode.getChild(i);
                    Object key = ctx.decode(cn.getChild("key"), childKeyType, null, i + ".key");
                    Object value = ctx.decode(cn.getChild("value"), childValueType, result.get(key), i + ".value");
                    result.put(key, value);
                }
                return result;
            }
        }
        throw new BeanCoderException("Incorrect input, the input for type:" + cls + " has to be an array or map,  got" + StringUtil.toTrimmedStr((Object)TDJSONWriter.get().writeAsString(jsonNode), (int)500));
    }

    @Generated
    public static CoderMap getInstance() {
        return instance;
    }
}

