/*
 * Decompiled with CFR 0.152.
 */
package com.kloudless;

import com.kloudless.Application;
import com.kloudless.Client;
import com.kloudless.exceptions.ApiException;
import com.kloudless.exceptions.InvalidArgumentException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpResponse;

public class Account
extends Client {
    private String id;

    public Account(String token) throws InvalidArgumentException {
        this("me", token, "", new HashMap<String, Object>(), Application.getDefaultApiVersion());
    }

    public Account(String token, int apiVersion) throws InvalidArgumentException {
        this("me", token, "", new HashMap<String, Object>(), apiVersion);
    }

    public Account(String token, Map<String, Object> headers) throws InvalidArgumentException {
        this("me", token, "", headers, Application.getDefaultApiVersion());
    }

    public Account(String token, Map<String, Object> headers, int apiVersion) throws InvalidArgumentException {
        this("me", token, "", headers, apiVersion);
    }

    public Account(String accountId, String apiKey) throws InvalidArgumentException {
        this(accountId, "", apiKey, new HashMap<String, Object>(), Application.getDefaultApiVersion());
    }

    public Account(String accountId, String apiKey, int apiVersion) throws InvalidArgumentException {
        this(accountId, "", apiKey, new HashMap<String, Object>(), apiVersion);
    }

    public Account(String accountId, String apiKey, Map<String, Object> headers) throws InvalidArgumentException {
        this(accountId, "", apiKey, headers, Application.getDefaultApiVersion());
    }

    public Account(String accountId, String apiKey, Map<String, Object> headers, int apiVersion) throws InvalidArgumentException {
        this(accountId, "", apiKey, headers, apiVersion);
    }

    private Account(String accountId, String token, String apiKey, Map<String, Object> headers, int apiVersion) throws InvalidArgumentException {
        super(apiKey, token, headers, apiVersion);
        this.urlPrefix = super.getUrlPrefix() + "accounts/" + accountId;
        this.id = accountId;
    }

    public String getId() {
        return this.id;
    }

    public HttpResponse raw(String httpMethod, String url, Map<String, Object> headers, Map<String, Object> content) throws ApiException {
        httpMethod = httpMethod.toUpperCase();
        headers = Optional.ofNullable(headers).orElse(new HashMap());
        headers.put("X-Kloudless-Raw-URI", url);
        headers.put("X-Kloudless-Raw-Method", httpMethod);
        url = this.assembleUrl("/raw");
        headers = this.mergeHeaders(headers);
        return this.rawJsonExecute("POST", url, headers, content);
    }

    @Override
    public void setApiVersion(int apiVersion) {
        this.apiVersion = apiVersion;
        this.urlPrefix = String.format("/v%s/", this.apiVersion) + "accounts/" + this.id;
    }
}

