/*
 * Decompiled with CFR 0.152.
 */
package com.kloudless;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kloudless.SimpleClient;
import com.kloudless.exceptions.ApiException;
import com.kloudless.exceptions.InvalidArgumentException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;

public class Application {
    private static String baseUrl = "https://api.kloudless.com";
    private static String sdkVersion;
    private static int defaultApiVersion;
    private static int defaultAuthPathVersion;
    private static SimpleClient simpleClient;
    private static Gson gson;

    public static String getBaseUrl() {
        return baseUrl;
    }

    public static void setBaseUrl(String baseUrl) {
        Application.baseUrl = baseUrl;
    }

    public static String getSDKVersion() {
        return sdkVersion;
    }

    public static int getDefaultApiVersion() {
        return defaultApiVersion;
    }

    public static void setDefaultApiVersion(int defaultApiVersion) {
        Application.defaultApiVersion = defaultApiVersion;
    }

    public static int getDefaultAuthPathVersion() {
        return defaultAuthPathVersion;
    }

    public static void setDefaultAuthPathVersion(int defaultAuthPathVersion) {
        Application.defaultAuthPathVersion = defaultAuthPathVersion;
    }

    public static Map<String, String> getAuthorizationUrl(String appId, String redirectUrl) throws RuntimeException {
        return Application.getAuthorizationUrl(appId, redirectUrl, "all", null);
    }

    public static Map<String, String> getAuthorizationUrl(String appId, String redirectUrl, String scope) throws RuntimeException {
        return Application.getAuthorizationUrl(appId, redirectUrl, scope, null);
    }

    public static Map<String, String> getAuthorizationUrl(String appId, String redirectUrl, String scope, String state) throws RuntimeException {
        if (state == null) {
            try {
                state = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                state = UUID.randomUUID().toString();
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", appId);
        params.put("redirect_uri", redirectUrl);
        params.put("scope", scope);
        params.put("state", state);
        params.put("response_type", "code");
        String path = String.format("v%s/", defaultAuthPathVersion) + "oauth";
        try {
            URIBuilder uriBuilder = new URIBuilder(baseUrl).setPath(path);
            for (Map.Entry entry : params.entrySet()) {
                uriBuilder.addParameter((String)entry.getKey(), entry.getValue().toString());
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("url", uriBuilder.build().toURL().toString());
            result.put("state", state);
            return result;
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Generate autohrization url failed. ", e);
        }
    }

    public static String retrieveToken(String state, String origState, String code, String origRedirectUrl, String appId, String apiKey) throws InvalidArgumentException, ApiException {
        if (!origState.equals(state)) {
            throw new InvalidArgumentException(String.format("State %s does not match original state %s", state, origState), null);
        }
        String url = String.format("/v%s/", defaultAuthPathVersion) + "oauth/token";
        try {
            return Application.getToken(url, Application.assembleTokenRetrievingContent(code, origRedirectUrl, appId, apiKey));
        }
        catch (IOException | ParseException e) {
            throw new ApiException("Get token failed, " + e.getMessage(), (Exception)e);
        }
    }

    public static boolean verifyToken(String token, String appId) throws ApiException {
        try {
            String verifyData = Application.getApplicationId(token);
            return verifyData.equals(appId);
        }
        catch (IOException | ParseException e) {
            throw new ApiException("Verify token failed " + e.getMessage(), (Exception)e);
        }
    }

    private static String getApplicationId(String token) throws ApiException, ClientProtocolException, ParseException, IOException {
        String url = String.format("/v%s/", defaultAuthPathVersion) + "oauth/token";
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authorization", "Bearer " + token);
        HttpResponse response = simpleClient.rawFormExecute("GET", url, headers, null);
        JsonObject data = (JsonObject)gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JsonObject.class);
        Optional<JsonElement> clientId = Optional.ofNullable(data.get("client_id"));
        return clientId.isPresent() ? clientId.get().getAsString() : "";
    }

    private static Map<String, Object> assembleTokenRetrievingContent(String code, String origRedirectUrl, String appId, String apiKey) {
        HashMap<String, Object> requestContent = new HashMap<String, Object>();
        requestContent.put("grant_type", "authorization_code");
        requestContent.put("code", code);
        requestContent.put("redirect_uri", origRedirectUrl);
        requestContent.put("client_id", appId);
        requestContent.put("client_secret", apiKey);
        return requestContent;
    }

    private static String getToken(String url, Map<String, Object> httpContent) throws ClientProtocolException, ApiException, ParseException, IOException {
        HttpResponse response = simpleClient.rawFormExecute("POST", url, null, httpContent);
        JsonObject jsonObject = (JsonObject)gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JsonObject.class);
        return jsonObject.get("access_token").getAsString();
    }

    static {
        defaultApiVersion = 1;
        defaultAuthPathVersion = 1;
        simpleClient = new SimpleClient();
        gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Properties properties = new Properties();
            properties.load(new BufferedReader(new InputStreamReader(Application.class.getClassLoader().getResourceAsStream("app.properties"))));
            sdkVersion = properties.getProperty("version");
        }
        catch (IOException e) {
            throw new RuntimeException("Read version properties file failed.", e);
        }
    }
}

