/*
 * Decompiled with CFR 0.152.
 */
package com.kloudless;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.kloudless.Application;
import com.kloudless.exceptions.ApiException;
import com.kloudless.models.Resource;
import com.kloudless.models.ResourceList;
import com.kloudless.models.ResponseBase;
import com.kloudless.models.ResponseJson;
import com.kloudless.models.ResponseRaw;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public abstract class BaseHttpClient {
    static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public abstract String getUrlPrefix();

    public abstract Map<String, Object> getDefaultHeaders();

    public abstract Map<String, Object> getDefaultQueryParameters();

    public ResponseBase get(String url) throws ApiException {
        return this.get(url, null);
    }

    public ResponseBase get(String url, Map<String, Object> headers) throws ApiException {
        return this.runHttpTransaction("GET", url, "Json", headers, null);
    }

    public ResponseRaw getBinary(String url) throws ApiException {
        return this.getBinary(url, null);
    }

    public ResponseRaw getBinary(String url, Map<String, Object> headers) throws ApiException {
        return (ResponseRaw)this.runHttpTransaction("GET", url, "Json", headers, null, false);
    }

    public ResponseBase post(String url, Map<String, Object> content) throws ApiException {
        return this.post(url, null, content);
    }

    public ResponseBase post(String url, Map<String, Object> headers, Map<String, Object> content) throws ApiException {
        return this.runHttpTransaction("POST", url, "Json", headers, content);
    }

    public ResponseBase post(String url, Map<String, Object> headers, File uploadFile) throws ApiException {
        return this.runHttpTransaction("POST", url, "File", headers, uploadFile);
    }

    public ResponseBase patch(String url, Map<String, Object> content) throws ApiException {
        return this.patch(url, null, content);
    }

    public ResponseBase patch(String url, Map<String, Object> headers, Map<String, Object> content) throws ApiException {
        return this.runHttpTransaction("PATCH", url, "Json", headers, content);
    }

    public ResponseBase patch(String url, Map<String, Object> headers, File uploadFile) throws ApiException {
        return this.runHttpTransaction("PATCH", url, "File", headers, uploadFile);
    }

    public ResponseBase put(String url, Map<String, Object> content) throws ApiException {
        return this.put(url, null, content);
    }

    public ResponseBase put(String url, Map<String, Object> headers, Map<String, Object> content) throws ApiException {
        return this.runHttpTransaction("PUT", url, "Json", headers, content);
    }

    public ResponseBase put(String url, Map<String, Object> headers, File uploadFile) throws ApiException {
        return this.runHttpTransaction("PUT", url, "File", headers, uploadFile);
    }

    public ResponseBase delete(String url) throws ApiException {
        return this.delete(url, null);
    }

    public ResponseBase delete(String url, Map<String, Object> headers) throws ApiException {
        return this.runHttpTransaction("DELETE", url, "Json", headers, null);
    }

    private ResponseBase runHttpTransaction(String method, String url, String format, Map<String, Object> headers, Object content) throws ApiException {
        return this.runHttpTransaction(method, url, format, headers, content, true);
    }

    private ResponseBase runHttpTransaction(String method, String url, String format, Map<String, Object> headers, Object content, Boolean tryJson) throws ApiException {
        HttpResponse httpResponse;
        url = this.assembleUrl(url);
        headers = this.mergeHeaders(headers);
        switch (format = format.toUpperCase()) {
            case "JSON": {
                httpResponse = this.rawJsonExecute(method, url, headers, content);
                break;
            }
            case "FORM": {
                httpResponse = this.rawFormExecute(method, url, headers, content);
                break;
            }
            case "FILE": {
                httpResponse = this.rawFileExecute(method, url, headers, content);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid HTTP method: " + format);
            }
        }
        return this.responseFactory(httpResponse, url, headers, method, tryJson);
    }

    protected HttpResponse rawFormExecute(String method, String url, Map<String, Object> headers, Object content) throws ApiException {
        try {
            content = Optional.ofNullable(content).orElse(new HashMap());
            ArrayList<BasicNameValuePair> requestContent = new ArrayList<BasicNameValuePair>();
            for (Map.Entry entry : ((Map)content).entrySet()) {
                requestContent.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(requestContent);
            return BaseHttpClient.handleResponse(BaseHttpClient.assembleHttpRequest(method, url, (HttpEntity)entity, headers, ContentType.APPLICATION_FORM_URLENCODED.getMimeType()));
        }
        catch (ApiException | IOException | ParseException e) {
            throw new ApiException("Run http " + method + " to " + url + " failed, " + e.getMessage(), (Exception)e);
        }
    }

    protected HttpResponse rawJsonExecute(String method, String url, Map<String, Object> headers, Object content) throws ApiException {
        try {
            content = Optional.ofNullable(content).orElse(new HashMap());
            StringEntity entity = new StringEntity(gson.toJson(content).toString());
            return BaseHttpClient.handleResponse(BaseHttpClient.assembleHttpRequest(method, url, (HttpEntity)entity, headers, ContentType.APPLICATION_JSON.getMimeType()));
        }
        catch (ApiException | IOException | ParseException e) {
            throw new ApiException("Run http " + method + " to " + url + " failed, " + e.getMessage(), (Exception)e);
        }
    }

    protected HttpResponse rawFileExecute(String method, String url, Map<String, Object> headers, Object uploadFile) throws ApiException {
        try {
            HttpEntity entity = EntityBuilder.create().setFile((File)uploadFile).build();
            return BaseHttpClient.handleResponse(BaseHttpClient.assembleHttpRequest(method, url, entity, headers, ContentType.APPLICATION_OCTET_STREAM.getMimeType()));
        }
        catch (ApiException | IOException | ParseException e) {
            throw new ApiException("Run http " + method + " to " + url + " failed, " + e.getMessage(), (Exception)e);
        }
    }

    private static HttpRequestBase assembleHttpRequest(String method, String url, HttpEntity entity, Map<String, Object> headers, String contentType) throws UnsupportedEncodingException {
        HttpRequestBase request = BaseHttpClient.requestFactory(method, Application.getBaseUrl() + url, entity);
        request = BaseHttpClient.assembleHeaders(request, headers, contentType);
        return request;
    }

    private static HttpResponse handleResponse(HttpRequestBase request) throws ClientProtocolException, IOException, ApiException, ParseException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
            throw new ApiException("Get error response from API server, status code:" + response.getStatusLine().getStatusCode() + ", and its message" + EntityUtils.toString((HttpEntity)response.getEntity()), null);
        }
        return response;
    }

    protected Map<String, Object> mergeHeaders(Map<String, Object> headers) {
        headers = Optional.ofNullable(headers).orElse(new HashMap());
        HashMap<String, Object> mergedMap = new HashMap<String, Object>();
        mergedMap.putAll(this.getDefaultHeaders());
        mergedMap.putAll(headers);
        return mergedMap;
    }

    private static HttpRequestBase assembleHeaders(HttpRequestBase request, Map<String, Object> headers, String contentType) {
        headers = Optional.ofNullable(headers).orElse(new HashMap());
        for (Map.Entry entry : headers.entrySet()) {
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        request.addHeader("User-Agent", "kloudless-java/" + Application.getSDKVersion());
        request.addHeader("Content-Type", contentType);
        return request;
    }

    protected String assembleUrl(String url) {
        return this.getUrlPrefix() + this.appendDefaultQueryParameters(url);
    }

    private String appendDefaultQueryParameters(String url) {
        if (url.indexOf("?") != -1) {
            String[] urls = url.split("\\?");
            url = urls[0] + "?" + BaseHttpClient.toQueryString(this.mergeDeaultQueryParameters(this.getQueryParams(url)));
        } else {
            String queryString = BaseHttpClient.toQueryString(this.mergeDeaultQueryParameters(new HashMap<String, String>()));
            if (!queryString.isEmpty()) {
                url = url + "?" + queryString;
            }
        }
        return url;
    }

    private Map<String, String> getQueryParams(String url) {
        String[] urls = url.split("\\?");
        String[] queryString = urls[1].split("&");
        return Arrays.asList(queryString).stream().map(param -> param.split("=", 2)).collect(Collectors.toMap(a -> a[0], a -> a[1]));
    }

    private Map<String, String> mergeDeaultQueryParameters(Map<String, String> querys) {
        for (Map.Entry<String, Object> entry : this.getDefaultQueryParameters().entrySet()) {
            if (querys.containsKey(entry.getKey())) continue;
            querys.put(entry.getKey(), (String)entry.getValue());
        }
        return querys;
    }

    private static String toQueryString(Map<String, String> queryParameters) {
        return queryParameters.entrySet().stream().map(element -> (String)element.getKey() + "=" + (String)element.getValue()).collect(Collectors.joining("&"));
    }

    private static HttpRequestBase requestFactory(String method, String url, HttpEntity entity) throws UnsupportedEncodingException {
        switch (method) {
            case "GET": {
                return new HttpGet(url);
            }
            case "POST": {
                HttpPost post = new HttpPost(url);
                post.setEntity(entity);
                return post;
            }
            case "PUT": {
                HttpPut put = new HttpPut(url);
                put.setEntity(entity);
                return put;
            }
            case "PATCH": {
                HttpPatch patch = new HttpPatch(url);
                patch.setEntity(entity);
                return patch;
            }
            case "DELETE": {
                return new HttpDelete(url);
            }
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + method);
    }

    private ResponseBase responseFactory(HttpResponse response, String url, Map<String, Object> headers, String method, Boolean tryJson) throws ApiException {
        if (response != null && response.getEntity() != null && tryJson.booleanValue() && ContentType.get((HttpEntity)response.getEntity()).toString().equals(ContentType.APPLICATION_JSON.getMimeType())) {
            try {
                JsonObject data = (JsonObject)gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JsonObject.class);
                if (data.has("type") && "object_list".equals(data.get("type").getAsString())) {
                    ArrayList<Resource> tmpList = new ArrayList<Resource>();
                    JsonArray array = data.get("objects").getAsJsonArray();
                    for (int i = 0; i < array.size(); ++i) {
                        JsonObject element = array.get(i).getAsJsonObject();
                        Resource one = new Resource(element, BaseHttpClient.generateResourceUrl(url, element, method, true), headers);
                        tmpList.add(one);
                    }
                    ResourceList rList = new ResourceList(url, headers, tmpList, data);
                    return rList;
                }
                if (data.has("id")) {
                    return new Resource(data, BaseHttpClient.generateResourceUrl(url, data, method, false), headers);
                }
                return new ResponseJson(data, url, headers);
            }
            catch (JsonSyntaxException | IOException | URISyntaxException | ParseException e) {
                throw new ApiException("Generate Resource object failed, " + e.getMessage(), (Exception)e);
            }
        }
        return new ResponseRaw(response, url, headers);
    }

    private static String generateResourceUrl(String url, JsonObject data, String method, boolean isListUrl) throws URISyntaxException {
        if (url.indexOf("?") != -1) {
            String[] unhandledUrl = url.split("\\?");
            return BaseHttpClient.assembleUrlWithId(unhandledUrl[0], data, method, isListUrl) + "?" + unhandledUrl[1];
        }
        return BaseHttpClient.assembleUrlWithId(url, data, method, isListUrl);
    }

    private static String assembleUrlWithId(String url, JsonObject data, String method, boolean isListUrl) throws URISyntaxException {
        Optional<JsonElement> href = Optional.ofNullable(data.get("href"));
        if (href.isPresent()) {
            String fromHref = href.get().getAsString();
            URI tempUrl = new URIBuilder(fromHref).build();
            return tempUrl.getPath();
        }
        Optional<JsonElement> id = Optional.ofNullable(data.get("id"));
        if (id.isPresent()) {
            String dataType;
            Optional<JsonElement> dataOptional = Optional.ofNullable(data.get("type"));
            Optional<JsonElement> apiOptional = Optional.ofNullable(data.get("api"));
            String apiType = apiOptional.isPresent() ? apiOptional.get().getAsString() : "";
            String string = dataType = dataOptional.isPresent() ? dataOptional.get().getAsString() : "";
            if (apiType.equals("storage")) {
                URI tempUrl = new URIBuilder(url).build();
                String[] paths = tempUrl.getPath().split("/");
                return String.join((CharSequence)"/", Arrays.asList(paths).subList(0, 4)) + String.format("/%s/%ss/%s", apiType, dataType, id.get().getAsString());
            }
            if (method.equals("POST") || isListUrl) {
                URI tempUrl = new URIBuilder(url).build();
                return tempUrl.getPath() + "/" + id.get().getAsString();
            }
        }
        return url;
    }
}

