/*
 * Decompiled with CFR 0.152.
 */
package com.kloudless;

import com.kloudless.Application;
import com.kloudless.BaseHttpClient;
import com.kloudless.exceptions.InvalidArgumentException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Client
extends BaseHttpClient {
    private String apiKey;
    private String token;
    protected int apiVersion;
    protected String urlPrefix;
    protected Map<String, Object> defaultHeaders;

    public Client(String apiKey, Map<String, Object> headers) throws InvalidArgumentException {
        this(apiKey, "", headers, Application.getDefaultApiVersion());
    }

    public Client(String apiKey, Map<String, Object> headers, int apiVersion) throws InvalidArgumentException {
        this(apiKey, "", headers, apiVersion);
    }

    protected Client(String apiKey, String token, Map<String, Object> headers, int apiVersion) throws InvalidArgumentException {
        this.apiKey = apiKey;
        this.token = token;
        this.defaultHeaders = Optional.ofNullable(headers).orElse(new HashMap());
        this.apiVersion = apiVersion;
        if (this.token != null && !this.token.isEmpty()) {
            this.defaultHeaders.put("Authorization", "Bearer " + this.token);
        } else if (this.apiKey != null && !this.apiKey.isEmpty()) {
            this.defaultHeaders.put("Authorization", "APIKey " + this.apiKey);
        } else {
            throw new InvalidArgumentException("Initialize Client failure, neither token nor apiKey.", null);
        }
        this.urlPrefix = String.format("/v%s/", this.apiVersion);
    }

    @Override
    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    @Override
    public Map<String, Object> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    @Override
    public Map<String, Object> getDefaultQueryParameters() {
        return new HashMap<String, Object>();
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(int apiVersion) {
        this.apiVersion = apiVersion;
        this.urlPrefix = String.format("/v%s/", this.apiVersion);
    }
}

