/*
 * Decompiled with CFR 0.152.
 */
package com.kloudless.models;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kloudless.exceptions.ApiException;
import com.kloudless.models.ResponseBase;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;

public class Resource
extends ResponseBase {
    private JsonObject data;
    private String id;

    public Resource(JsonObject data, String url, Map<String, Object> defaultHeaders) throws URISyntaxException {
        this.url = this.storeAndRemoveQueryString(url);
        this.data = data;
        this.id = this.retrieveId(data);
        this.defaultHeaders = defaultHeaders;
    }

    private String retrieveId(JsonObject data) {
        Optional<JsonElement> id = Optional.ofNullable(data.get("id"));
        return id.isPresent() ? id.get().getAsString() : "";
    }

    public JsonObject getData() {
        return this.data;
    }

    public String getId() {
        return this.id;
    }

    public void refresh() throws ApiException {
        Resource newResource = (Resource)super.get("");
        this.data = newResource.getData();
    }
}

